/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.relation;

import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.FieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public final class RelationUtil {
    private RelationUtil() {
    }

    public static <V extends FeatureVector<?>> VectorFieldTypeInformation<V> assumeVectorField(Relation<V> relation) {
        try {
            return (VectorFieldTypeInformation)relation.getDataTypeInformation();
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Expected a vector field, got type information: " + relation.getDataTypeInformation().toString(), exception);
        }
    }

    public static <V extends NumberVector> NumberVector.Factory<V> getNumberVectorFactory(Relation<V> relation) {
        VectorFieldTypeInformation<V> vectorFieldTypeInformation = RelationUtil.assumeVectorField(relation);
        NumberVector.Factory factory = (NumberVector.Factory)vectorFieldTypeInformation.getFactory();
        return factory;
    }

    public static int dimensionality(Relation<? extends SpatialComparable> relation) {
        SimpleTypeInformation<? extends SpatialComparable> simpleTypeInformation = relation.getDataTypeInformation();
        if (simpleTypeInformation instanceof FieldTypeInformation) {
            return ((FieldTypeInformation)((Object)simpleTypeInformation)).getDimensionality();
        }
        return -1;
    }

    public static double[][] computeMinMax(Relation<? extends NumberVector> relation) {
        int n = RelationUtil.dimensionality(relation);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Double.MAX_VALUE;
            dArray2[i] = -1.7976931348623157E308;
        }
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            NumberVector numberVector = relation.get(dBIDIter);
            for (int i = 0; i < n; ++i) {
                double d = numberVector.doubleValue(i);
                dArray[i] = d < dArray[i] ? d : dArray[i];
                dArray2[i] = d > dArray2[i] ? d : dArray2[i];
            }
            dBIDIter.advance();
        }
        return new double[][]{dArray, dArray2};
    }

    public static double[] variances(Relation<? extends NumberVector> relation, NumberVector numberVector, DBIDs dBIDs) {
        int n = dBIDs.size();
        double[] dArray = new double[numberVector.getDimensionality()];
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            NumberVector numberVector2 = relation.get(dBIDIter);
            int n2 = 0;
            while (n2 < numberVector.getDimensionality()) {
                double d = numberVector2.doubleValue(n2) - numberVector.doubleValue(n2);
                int n3 = n2++;
                dArray[n3] = dArray[n3] + d * d / (double)n;
            }
            dBIDIter.advance();
        }
        return dArray;
    }

    public static double[][] relationAsMatrix(Relation<? extends NumberVector> relation, ArrayDBIDs arrayDBIDs) {
        int n = arrayDBIDs.size();
        int n2 = RelationUtil.dimensionality(relation);
        double[][] dArray = new double[n][n2];
        int n3 = 0;
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        while (dBIDArrayIter.valid()) {
            NumberVector numberVector = relation.get(dBIDArrayIter);
            double[] dArray2 = dArray[n3];
            for (int i = 0; i < n2; ++i) {
                dArray2[i] = numberVector.doubleValue(i);
            }
            dBIDArrayIter.advance();
            ++n3;
        }
        assert (n3 == n);
        return dArray;
    }

    public static <V extends SpatialComparable> String getColumnLabel(Relation<? extends V> relation, int n) {
        SimpleTypeInformation<? extends V> simpleTypeInformation = relation.getDataTypeInformation();
        if (!(simpleTypeInformation instanceof VectorFieldTypeInformation)) {
            return "Column " + n;
        }
        VectorFieldTypeInformation vectorFieldTypeInformation = (VectorFieldTypeInformation)simpleTypeInformation;
        String string = vectorFieldTypeInformation.getLabel(n);
        return string != null ? string : "Column " + n;
    }

    public static <V extends NumberVector, T extends NumberVector> Relation<V> relationUglyVectorCast(Relation<T> relation) {
        return relation;
    }

    public static class DescendingByDoubleRelation
    implements Comparator<DBIDRef> {
        private final DoubleRelation scores;

        public DescendingByDoubleRelation(DoubleRelation doubleRelation) {
            this.scores = doubleRelation;
        }

        @Override
        public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            return Double.compare(this.scores.doubleValue(dBIDRef2), this.scores.doubleValue(dBIDRef));
        }
    }

    public static class AscendingByDoubleRelation
    implements Comparator<DBIDRef> {
        private final DoubleRelation scores;

        public AscendingByDoubleRelation(DoubleRelation doubleRelation) {
            this.scores = doubleRelation;
        }

        @Override
        public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            return Double.compare(this.scores.doubleValue(dBIDRef), this.scores.doubleValue(dBIDRef2));
        }
    }

    public static class CollectionFromRelation<O>
    extends AbstractCollection<O>
    implements Collection<O> {
        Relation<? extends O> db;

        public CollectionFromRelation(Relation<? extends O> relation) {
            this.db = relation;
        }

        @Override
        public Iterator<O> iterator() {
            return new RelationObjectIterator<O>(this.db);
        }

        @Override
        public int size() {
            return this.db.size();
        }
    }

    public static class RelationObjectIterator<O>
    implements Iterator<O> {
        final DBIDIter iter;
        final Relation<? extends O> database;

        public RelationObjectIterator(DBIDIter dBIDIter, Relation<? extends O> relation) {
            this.iter = dBIDIter;
            this.database = relation;
        }

        public RelationObjectIterator(Relation<? extends O> relation) {
            this.database = relation;
            this.iter = relation.iterDBIDs();
        }

        @Override
        public boolean hasNext() {
            return this.iter.valid();
        }

        @Override
        public O next() {
            O o = this.database.get(this.iter);
            this.iter.advance();
            return o;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

