/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Description(value="This class generates a sequence of DBIDs to 'load' into a database. This is useful when using an external data matrix, and not requiring access to the actual vectors.")
public class DBIDRangeDatabaseConnection
implements DatabaseConnection {
    int start;
    int count;

    public DBIDRangeDatabaseConnection(int n, int n2) {
        this.start = n;
        this.count = n2;
    }

    @Override
    public MultipleObjectsBundle loadData() {
        MultipleObjectsBundle multipleObjectsBundle = new MultipleObjectsBundle();
        multipleObjectsBundle.setDBIDs(DBIDFactory.FACTORY.generateStaticDBIDRange(this.start, this.count));
        return multipleObjectsBundle;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID START_ID = new OptionID("idgen.start", "First integer DBID to generate.");
        public static final OptionID COUNT_ID = new OptionID("idgen.count", "Number of DBID to generate.");
        int start;
        int count;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            IntParameter intParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter2 = new IntParameter(START_ID, 0);
            if (parameterization.grab(intParameter2)) {
                this.start = intParameter2.intValue();
            }
            if (parameterization.grab(intParameter = new IntParameter(COUNT_ID))) {
                this.count = intParameter.intValue();
            }
        }

        @Override
        protected DBIDRangeDatabaseConnection makeInstance() {
            return new DBIDRangeDatabaseConnection(this.start, this.count);
        }
    }
}

