/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.data.ExternalID;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.AbstractDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;

public class ExternalIDJoinDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(ExternalIDJoinDatabaseConnection.class);
    protected final List<DatabaseConnection> sources;

    public ExternalIDJoinDatabaseConnection(List<ObjectFilter> list, List<DatabaseConnection> list2) {
        super(list);
        this.sources = list2;
    }

    @Override
    public MultipleObjectsBundle loadData() {
        int n;
        int externalID;
        ArrayList<MultipleObjectsBundle> arrayList = new ArrayList<MultipleObjectsBundle>(this.sources.size());
        for (DatabaseConnection object2 : this.sources) {
            arrayList.add(object2.loadData());
        }
        MultipleObjectsBundle multipleObjectsBundle = (MultipleObjectsBundle)arrayList.get(0);
        TObjectIntHashMap<ExternalID> tObjectIntHashMap = new TObjectIntHashMap<ExternalID>(multipleObjectsBundle.dataLength(), 0.5f, -1);
        int multipleObjectsBundle2 = -1;
        for (externalID = 0; externalID < multipleObjectsBundle.metaLength(); ++externalID) {
            if (!TypeUtil.EXTERNALID.isAssignableFromType(multipleObjectsBundle.meta(externalID))) continue;
            multipleObjectsBundle2 = externalID;
            break;
        }
        if ((n = multipleObjectsBundle2) == -1) {
            throw new AbortException("No external ID column found in primary source.");
        }
        for (multipleObjectsBundle2 = 0; multipleObjectsBundle2 < multipleObjectsBundle.dataLength(); ++multipleObjectsBundle2) {
            ExternalID stringBuilder = (ExternalID)multipleObjectsBundle.data(multipleObjectsBundle2, n);
            if (stringBuilder == null) {
                LOG.debug("Object without ID encountered.");
                continue;
            }
            int n7 = tObjectIntHashMap.put(stringBuilder, multipleObjectsBundle2);
            if (n7 == -1) continue;
            LOG.debug("Duplicate id encountered: " + stringBuilder + " in rows " + n7 + " and " + multipleObjectsBundle2);
        }
        for (n = 1; n < this.sources.size(); ++n) {
            int n2;
            Object object;
            int n3;
            MultipleObjectsBundle multipleObjectsBundle3 = (MultipleObjectsBundle)arrayList.get(n);
            int stringBuilder = -1;
            for (n3 = 0; n3 < multipleObjectsBundle3.metaLength(); ++n3) {
                if (!TypeUtil.EXTERNALID.isAssignableFromType(multipleObjectsBundle3.meta(n3))) continue;
                stringBuilder = n3;
                break;
            }
            if ((externalID = stringBuilder) == -1) {
                StringBuilder arrayList2 = new StringBuilder();
                for (n3 = 0; n3 < multipleObjectsBundle3.metaLength(); ++n3) {
                    if (arrayList2.length() > 0) {
                        arrayList2.append(',');
                    }
                    arrayList2.append(multipleObjectsBundle3.meta(n3));
                }
                throw new AbortException("No external ID column found in source " + (n + 1) + " to join with. Got: " + arrayList2.toString());
            }
            ArrayList<Object> i = new ArrayList<Object>(multipleObjectsBundle3.metaLength());
            for (n3 = 0; n3 < multipleObjectsBundle3.metaLength(); ++n3) {
                if (n3 == externalID) {
                    i.add(null);
                    continue;
                }
                object = new ArrayList(multipleObjectsBundle.dataLength());
                for (n2 = 0; n2 < multipleObjectsBundle.dataLength(); ++n2) {
                    ((ArrayList)object).add(null);
                }
                multipleObjectsBundle.appendColumn(multipleObjectsBundle3.meta(n3), (List<?>)object);
                i.add(object);
            }
            for (n3 = 0; n3 < multipleObjectsBundle3.dataLength(); ++n3) {
                object = (ExternalID)multipleObjectsBundle3.data(n3, externalID);
                if (object == null) {
                    LOG.warning("Object without label encountered.");
                    continue;
                }
                n2 = tObjectIntHashMap.get(object);
                if (n2 == -1) {
                    LOG.debug("ID not found for join: " + object + " in row " + n3);
                    continue;
                }
                for (int j = 0; j < multipleObjectsBundle3.metaLength(); ++j) {
                    if (j == externalID) continue;
                    List list = (List)i.get(j);
                    assert (list != null);
                    list.set(n2, multipleObjectsBundle3.data(n3, j));
                }
            }
        }
        block10: for (n = 0; n < multipleObjectsBundle.dataLength(); ++n) {
            for (multipleObjectsBundle2 = 0; multipleObjectsBundle2 < multipleObjectsBundle.metaLength(); ++multipleObjectsBundle2) {
                if (multipleObjectsBundle.data(n, multipleObjectsBundle2) != null) continue;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    if (multipleObjectsBundle.data(n, i) == null) {
                        stringBuilder.append("null");
                        continue;
                    }
                    stringBuilder.append(multipleObjectsBundle.data(n, i));
                }
                LOG.warning("null value in joined data, row " + n + " column " + multipleObjectsBundle2 + FormatUtil.NEWLINE + "[" + stringBuilder.toString() + "]");
                continue block10;
            }
        }
        return multipleObjectsBundle;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabaseConnection.Parameterizer {
        public static final OptionID SOURCES_ID = new OptionID("join.sources", "The data sources to join.");
        protected List<DatabaseConnection> sources;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            super.configFilters(parameterization);
            ObjectListParameter objectListParameter = new ObjectListParameter(SOURCES_ID, DatabaseConnection.class);
            if (parameterization.grab(objectListParameter)) {
                this.sources = objectListParameter.instantiateClasses(parameterization);
            }
        }

        @Override
        protected ExternalIDJoinDatabaseConnection makeInstance() {
            return new ExternalIDJoinDatabaseConnection(this.filters, this.sources);
        }
    }
}

