/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorConversionFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenPair;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCARunner;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

@Alias(value={"whiten", "whitening", "pca"})
public class GlobalPrincipalComponentAnalysisTransform<O extends NumberVector>
extends AbstractVectorConversionFilter<O, O> {
    private static final Logging LOG = Logging.getLogger(GlobalPrincipalComponentAnalysisTransform.class);
    EigenPairFilter filter = null;
    int dim = -1;
    CovarianceMatrix covmat = null;
    double[][] proj = null;
    double[] buf = null;
    double[] mean = null;

    public GlobalPrincipalComponentAnalysisTransform(EigenPairFilter eigenPairFilter) {
        this.filter = eigenPairFilter;
    }

    @Override
    protected boolean prepareStart(SimpleTypeInformation<O> simpleTypeInformation) {
        if (!(simpleTypeInformation instanceof VectorFieldTypeInformation)) {
            throw new AbortException("PCA can only applied to fixed dimensionality vectors");
        }
        this.dim = ((VectorFieldTypeInformation)simpleTypeInformation).getDimensionality();
        this.covmat = new CovarianceMatrix(this.dim);
        return true;
    }

    @Override
    protected void prepareProcessInstance(O o) {
        this.covmat.put((NumberVector)o);
    }

    @Override
    protected void prepareComplete() {
        this.mean = this.covmat.getMeanVector().getArrayRef();
        PCAResult pCAResult = new PCARunner(null).processCovarMatrix(this.covmat.destroyToSampleMatrix());
        SortedEigenPairs sortedEigenPairs = pCAResult.getEigenPairs();
        this.covmat = null;
        if (this.filter == null) {
            this.proj = new double[this.dim][this.dim];
            for (int i = 0; i < this.dim; ++i) {
                EigenPair eigenPair = sortedEigenPairs.getEigenPair(i);
                double[] dArray = eigenPair.getEigenvector().getArrayRef();
                double d = Math.sqrt(eigenPair.getEigenvalue());
                for (int j = 0; j < this.dim; ++j) {
                    this.proj[i][j] = dArray[j] / d;
                }
            }
        } else {
            List<EigenPair> list = this.filter.filter(sortedEigenPairs).getStrongEigenPairs();
            int n = list.size();
            if (LOG.isVerbose()) {
                LOG.verbose("Reducing dimensionality from " + this.dim + " to " + n + " via PCA.");
            }
            this.proj = new double[n][this.dim];
            for (int i = 0; i < n; ++i) {
                EigenPair eigenPair = list.get(i);
                double[] dArray = eigenPair.getEigenvector().getArrayRef();
                double d = Math.sqrt(eigenPair.getEigenvalue());
                for (int j = 0; j < this.dim; ++j) {
                    this.proj[i][j] = dArray[j] / d;
                }
            }
        }
        this.buf = new double[this.dim];
    }

    @Override
    protected O filterSingleObject(O o) {
        for (int i = 0; i < this.dim; ++i) {
            this.buf[i] = o.doubleValue(i) - this.mean[i];
        }
        double[] dArray = VMath.times(this.proj, this.buf);
        return (O)this.factory.newNumberVector(dArray);
    }

    @Override
    protected SimpleTypeInformation<? super O> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    protected SimpleTypeInformation<? super O> convertedType(SimpleTypeInformation<O> simpleTypeInformation) {
        this.initializeOutputType(simpleTypeInformation);
        return new VectorFieldTypeInformation(this.factory, this.proj.length);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID FILTER_ID = new OptionID("globalpca.filter", "Filter to use for dimensionality reduction.");
        EigenPairFilter filter = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(FILTER_ID, EigenPairFilter.class, true);
            if (parameterization.grab(objectParameter)) {
                this.filter = (EigenPairFilter)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected GlobalPrincipalComponentAnalysisTransform<O> makeInstance() {
            return new GlobalPrincipalComponentAnalysisTransform(this.filter);
        }
    }
}

