/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.datasource.parser.StreamingParser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.io.TokenizedReader;
import de.lmu.ifi.dbs.elki.utilities.io.Tokenizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractStreamingParser
implements StreamingParser {
    protected TokenizedReader reader;
    protected Tokenizer tokenizer;

    public AbstractStreamingParser(CSVReaderFormat cSVReaderFormat) {
        this.reader = cSVReaderFormat.makeReader();
        this.tokenizer = this.reader.getTokenizer();
    }

    @Override
    public final MultipleObjectsBundle parse(InputStream inputStream) {
        this.initStream(inputStream);
        return MultipleObjectsBundle.fromStream(this);
    }

    @Override
    public void initStream(InputStream inputStream) {
        this.reader.reset(inputStream);
    }

    @Override
    public boolean hasDBIDs() {
        return false;
    }

    @Override
    public boolean assignDBID(DBIDVar dBIDVar) {
        dBIDVar.unset();
        return false;
    }

    @Override
    public MultipleObjectsBundle asMultipleObjectsBundle() {
        return MultipleObjectsBundle.fromStream(this);
    }

    @Override
    public void cleanup() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            this.getLogger().exception(iOException);
        }
    }

    protected abstract Logging getLogger();

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        protected CSVReaderFormat format;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            this.format = (CSVReaderFormat)ClassGenericsUtil.parameterizeOrAbort(CSVReaderFormat.class, parameterization);
        }

        @Override
        protected abstract AbstractStreamingParser makeInstance();
    }
}

