/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.colorhistogram;

import de.lmu.ifi.dbs.elki.distance.distancefunction.MatrixWeightedDistanceFunction;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ListSizeConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntListParameter;

@Reference(authors="J. R. Smith, S. F. Chang", title="VisualSEEk: a fully automated content-based image query system", booktitle="Proceedings of the fourth ACM international conference on Multimedia 1997", url="http://dx.doi.org/10.1145/244130.244151")
public class HSBHistogramQuadraticDistanceFunction
extends MatrixWeightedDistanceFunction {
    public static final OptionID BPP_ID = new OptionID("hsbhist.bpp", "The dimensionality of the histogram in hue, saturation and brightness.");

    public HSBHistogramQuadraticDistanceFunction(int n, int n2, int n3) {
        super(HSBHistogramQuadraticDistanceFunction.computeWeightMatrix(n, n2, n3));
    }

    public static Matrix computeWeightMatrix(int n, int n2, int n3) {
        int n4 = n * n2 * n3;
        assert (n4 > 0);
        Matrix matrix = new Matrix(n4, n4);
        for (int i = 0; i < n4; ++i) {
            int n5 = i / (n3 * n2);
            int n6 = i / n3 % n2;
            int n7 = i % n3;
            for (int j = 0; j < n4; ++j) {
                int n8 = j / (n3 * n2);
                int n9 = j / n3 % n2;
                int n10 = j % n3;
                double d = Math.cos(((double)n5 + 0.5) / (double)n * (Math.PI * 2));
                double d2 = Math.cos(((double)n8 + 0.5) / (double)n * (Math.PI * 2));
                double d3 = MathUtil.cosToSin(((double)n5 + 0.5) / (double)n * (Math.PI * 2), d);
                double d4 = MathUtil.cosToSin(((double)n8 + 0.5) / (double)n * (Math.PI * 2), d2);
                double d5 = d * ((double)n6 + 0.5) / (double)n2 - d2 * ((double)n9 + 0.5) / (double)n2;
                double d6 = d3 * ((double)n6 + 0.5) / (double)n2 - d4 * ((double)n9 + 0.5) / (double)n2;
                double d7 = (double)(n7 - n10) / (double)n3;
                double d8 = 1.0 - Math.sqrt((d7 * d7 + d6 * d6 + d5 * d5) / 5.0);
                matrix.set(i, j, d8);
            }
        }
        return matrix;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        return this.weightMatrix.equals(((HSBHistogramQuadraticDistanceFunction)object).weightMatrix);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        int quanth = 0;
        int quants = 0;
        int quantb = 0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntListParameter intListParameter = (IntListParameter)((IntListParameter)new IntListParameter(BPP_ID).addConstraint((ParameterConstraint)new ListSizeConstraint(3))).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT_LIST);
            if (parameterization.grab(intListParameter)) {
                int[] nArray = (int[])intListParameter.getValue();
                assert (nArray.length == 3);
                this.quanth = nArray[0];
                this.quants = nArray[1];
                this.quantb = nArray[2];
            }
        }

        @Override
        protected HSBHistogramQuadraticDistanceFunction makeInstance() {
            return new HSBHistogramQuadraticDistanceFunction(this.quanth, this.quants, this.quantb);
        }
    }
}

