/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.correlation;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.WeightedNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;
import java.util.Arrays;

public class WeightedSquaredPearsonCorrelationDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements WeightedNumberVectorDistanceFunction<NumberVector> {
    private double[] weights;

    public WeightedSquaredPearsonCorrelationDistanceFunction(double[] dArray) {
        this.weights = dArray;
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        double d = MathUtil.weightedPearsonCorrelationCoefficient(numberVector, numberVector2, this.weights);
        return 1.0 - d * d;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        return Arrays.equals(this.weights, ((WeightedSquaredPearsonCorrelationDistanceFunction)object).weights);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected double[] weights;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleListParameter doubleListParameter = new DoubleListParameter(WeightedNumberVectorDistanceFunction.WEIGHTS_ID);
            if (parameterization.grab(doubleListParameter)) {
                this.weights = (double[])((double[])doubleListParameter.getValue()).clone();
            }
        }

        @Override
        protected WeightedSquaredPearsonCorrelationDistanceFunction makeInstance() {
            return new WeightedSquaredPearsonCorrelationDistanceFunction(this.weights);
        }
    }
}

