/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.external;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractDBIDRangeDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.DiskCacheBasedDoubleDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.OnDiskUpperTriangleMatrix;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import java.io.File;
import java.io.IOException;

@Title(value="File based float distance for database objects.")
@Description(value="Loads float distance values from an external matrix.")
public class DiskCacheBasedFloatDistanceFunction
extends AbstractDBIDRangeDistanceFunction {
    private static final Logging LOG = Logging.getLogger(DiskCacheBasedFloatDistanceFunction.class);
    public static final int FLOAT_CACHE_MAGIC = 23423411;
    private OnDiskUpperTriangleMatrix cache;

    public DiskCacheBasedFloatDistanceFunction(OnDiskUpperTriangleMatrix onDiskUpperTriangleMatrix) {
        this.cache = onDiskUpperTriangleMatrix;
    }

    public DiskCacheBasedFloatDistanceFunction(File file) throws IOException {
        this.cache = new OnDiskUpperTriangleMatrix(file, 23423411, 0, 4, false);
    }

    @Override
    public double distance(int n, int n2) {
        if (n > n2) {
            return this.distance(n2, n);
        }
        try {
            return this.cache.getRecordBuffer(n, n2).getFloat();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Read error when loading distance " + n + "," + n2 + " from cache file.", iOException);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DiskCacheBasedFloatDistanceFunction diskCacheBasedFloatDistanceFunction = (DiskCacheBasedFloatDistanceFunction)object;
        return this.cache.equals(diskCacheBasedFloatDistanceFunction.cache);
    }

    @Override
    public void checkRange(DBIDRange dBIDRange) {
        if (this.cache.getMatrixSize() < dBIDRange.size()) {
            LOG.warning("Distance matrix has size " + this.cache.getMatrixSize() + " but range has size: " + dBIDRange.size());
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected OnDiskUpperTriangleMatrix cache = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            FileParameter fileParameter = new FileParameter(DiskCacheBasedDoubleDistanceFunction.Parameterizer.MATRIX_ID, FileParameter.FileType.INPUT_FILE);
            if (parameterization.grab(fileParameter)) {
                File file = (File)fileParameter.getValue();
                try {
                    this.cache = new OnDiskUpperTriangleMatrix(file, 23423411, 0, 4, false);
                }
                catch (IOException iOException) {
                    parameterization.reportError(new WrongParameterValueException(fileParameter, file.toString(), iOException));
                }
            }
        }

        @Override
        protected DiskCacheBasedFloatDistanceFunction makeInstance() {
            return new DiskCacheBasedFloatDistanceFunction(this.cache);
        }
    }
}

