/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"maximum", "max", "chebyshev", "de.lmu.ifi.dbs.elki.distance.distancefunction.MaximumDistanceFunction"})
public class MaximumDistanceFunction
extends LPNormDistanceFunction {
    public static final MaximumDistanceFunction STATIC = new MaximumDistanceFunction();

    @Deprecated
    public MaximumDistanceFunction() {
        super(Double.POSITIVE_INFINITY);
    }

    private final double preDistance(NumberVector numberVector, NumberVector numberVector2, int n, int n2, double d) {
        for (int i = n; i < n2; ++i) {
            double d2;
            double d3;
            double d4 = numberVector.doubleValue(i);
            double d5 = d3 = d4 >= (d2 = numberVector2.doubleValue(i)) ? d4 - d2 : d2 - d4;
            if (!(d3 > d)) continue;
            d = d3;
        }
        return d;
    }

    private final double preDistanceVM(NumberVector numberVector, SpatialComparable spatialComparable, int n, int n2, double d) {
        for (int i = n; i < n2; ++i) {
            double d2 = numberVector.doubleValue(i);
            double d3 = spatialComparable.getMin(i);
            double d4 = d3 - d2;
            if (d4 < 0.0) {
                d4 = d2 - spatialComparable.getMax(i);
            }
            if (!(d4 > d)) continue;
            d = d4;
        }
        return d;
    }

    private final double preDistanceMBR(SpatialComparable spatialComparable, SpatialComparable spatialComparable2, int n, int n2, double d) {
        for (int i = n; i < n2; ++i) {
            double d2 = spatialComparable2.getMin(i) - spatialComparable.getMax(i);
            if (d2 < 0.0) {
                d2 = spatialComparable.getMin(i) - spatialComparable2.getMax(i);
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private final double preNorm(NumberVector numberVector, int n, int n2, double d) {
        for (int i = n; i < n2; ++i) {
            double d2;
            double d3 = numberVector.doubleValue(i);
            double d4 = d2 = d3 >= 0.0 ? d3 : -d3;
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private final double preNormMBR(SpatialComparable spatialComparable, int n, int n2, double d) {
        for (int i = n; i < n2; ++i) {
            double d2 = spatialComparable.getMin(i);
            if (d2 < 0.0) {
                d2 = -spatialComparable.getMax(i);
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n;
        int n2 = numberVector.getDimensionality();
        int n3 = n2 < (n = numberVector2.getDimensionality()) ? n2 : n;
        double d = this.preDistance(numberVector, numberVector2, 0, n3, 0.0);
        if (n2 > n3) {
            d = this.preNorm(numberVector, n3, n2, d);
        } else if (n > n3) {
            d = this.preNorm(numberVector2, n3, n, d);
        }
        return d;
    }

    @Override
    public double norm(NumberVector numberVector) {
        return this.preNorm(numberVector, 0, numberVector.getDimensionality(), 0.0);
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n;
        int n2 = spatialComparable.getDimensionality();
        int n3 = n2 < (n = spatialComparable2.getDimensionality()) ? n2 : n;
        NumberVector numberVector = spatialComparable instanceof NumberVector ? (NumberVector)spatialComparable : null;
        NumberVector numberVector2 = spatialComparable2 instanceof NumberVector ? (NumberVector)spatialComparable2 : null;
        double d = 0.0;
        d = numberVector != null ? (numberVector2 != null ? this.preDistance(numberVector, numberVector2, 0, n3, d) : this.preDistanceVM(numberVector, spatialComparable2, 0, n3, d)) : (numberVector2 != null ? this.preDistanceVM(numberVector2, spatialComparable, 0, n3, d) : this.preDistanceMBR(spatialComparable, spatialComparable2, 0, n3, d));
        if (n2 > n3) {
            d = numberVector != null ? this.preNorm(numberVector, n3, n2, d) : this.preNormMBR(numberVector, n3, n2, d);
        }
        if (n > n3) {
            d = numberVector2 != null ? this.preNorm(numberVector2, n3, n, d) : this.preNormMBR(spatialComparable2, n3, n, d);
        }
        return d;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public String toString() {
        return "MaximumDistance";
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (this.getClass().equals(object.getClass())) {
            return true;
        }
        return super.equals(object);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected MaximumDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

