/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.set;

import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.query.DistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.set.AbstractSetDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.NormalizedPrimitiveSimilarityFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="P. Jaccard", title="Distribution de la florine alpine dans la Bassin de Dranses et dans quelques regiones voisines", booktitle="Bulletin del la Soci\u00e9t\u00e9 Vaudoise des Sciences Naturelles")
@Alias(value={"de.lmu.ifi.dbs.elki.distance.similarityfunction.JaccardPrimitiveSimilarityFunction"})
public class JaccardSimilarityDistanceFunction<O extends FeatureVector<?>>
extends AbstractSetDistanceFunction<O>
implements NormalizedPrimitiveSimilarityFunction<O>,
NumberVectorDistanceFunction<O>,
PrimitiveDistanceFunction<O> {
    @Override
    public double similarity(O o, O o2) {
        Object d;
        int n;
        if (o instanceof BitVector && o2 instanceof BitVector) {
            return ((BitVector)o).jaccardSimilarity((BitVector)o2);
        }
        if (o instanceof NumberVector && o2 instanceof NumberVector) {
            return JaccardSimilarityDistanceFunction.similarityNumberVector((NumberVector)o, (NumberVector)o2);
        }
        int n2 = o.getDimensionality();
        int n3 = o2.getDimensionality();
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < n2 && n < n3; ++n) {
            d = o.getValue(n);
            Object d2 = o2.getValue(n);
            boolean bl = JaccardSimilarityDistanceFunction.isNull(d);
            boolean bl2 = JaccardSimilarityDistanceFunction.isNull(d2);
            if (d instanceof Double && Double.isNaN((Double)d) || d2 instanceof Double && Double.isNaN((Double)d2) || bl && bl2) continue;
            ++n5;
            if (bl || !d.equals(d2)) continue;
            ++n4;
        }
        while (n < n2) {
            d = o.getValue(n);
            if (!(JaccardSimilarityDistanceFunction.isNull(d) || d instanceof Double && Double.isNaN((Double)d))) {
                ++n5;
            }
            ++n;
        }
        while (n < n3) {
            d = o2.getValue(n);
            if (!(JaccardSimilarityDistanceFunction.isNull(d) || d instanceof Double && Double.isNaN((Double)d))) {
                ++n5;
            }
            ++n;
        }
        return (double)n4 / (double)n5;
    }

    public static double similarityNumberVector(NumberVector numberVector, NumberVector numberVector2) {
        int n;
        int n2 = numberVector.getDimensionality();
        int n3 = numberVector2.getDimensionality();
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < n2 && n < n3; ++n) {
            double d = numberVector.doubleValue(n);
            double d2 = numberVector2.doubleValue(n);
            if (d != d || d2 != d2 || d == 0.0 && d2 == 0.0) continue;
            ++n5;
            if (d != d2) continue;
            ++n4;
        }
        while (n < n2) {
            if (numberVector.doubleValue(n) != 0.0) {
                ++n5;
            }
            ++n;
        }
        while (n < n3) {
            if (numberVector2.doubleValue(n) != 0.0) {
                ++n5;
            }
            ++n;
        }
        return (double)n4 / (double)n5;
    }

    @Override
    public double distance(O o, O o2) {
        return 1.0 - this.similarity(o, o2);
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        if (numberVector instanceof BitVector && numberVector2 instanceof BitVector) {
            return 1.0 - ((BitVector)numberVector).jaccardSimilarity((BitVector)numberVector2);
        }
        return 1.0 - JaccardSimilarityDistanceFunction.similarityNumberVector(numberVector, numberVector2);
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public SimpleTypeInformation<? super O> getInputTypeRestriction() {
        return TypeUtil.FEATURE_VECTORS;
    }

    @Override
    public <T extends O> DistanceSimilarityQuery<T> instantiate(Relation<T> relation) {
        return new PrimitiveDistanceSimilarityQuery<T>(relation, this, this);
    }
}

