/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.subspace;

import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.DimensionSelectingSubspaceDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntListParameter;

public abstract class AbstractDimensionsSelectingDistanceFunction<V extends FeatureVector<?>>
extends AbstractPrimitiveDistanceFunction<V>
implements PrimitiveDistanceFunction<V>,
DimensionSelectingSubspaceDistanceFunction<V> {
    protected long[] dimensions;

    public AbstractDimensionsSelectingDistanceFunction(long[] lArray) {
        this.dimensions = lArray;
    }

    @Override
    public double distance(V v, V v2) {
        return this.distance(v, v2);
    }

    @Override
    public long[] getSelectedDimensions() {
        return this.dimensions;
    }

    @Override
    public void setSelectedDimensions(long[] lArray) {
        if (this.dimensions == null || this.dimensions.length < lArray.length) {
            this.dimensions = (long[])lArray.clone();
            return;
        }
        BitsUtil.zeroI(this.dimensions);
        BitsUtil.orI(this.dimensions, lArray);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        return this.dimensions.equals(((AbstractDimensionsSelectingDistanceFunction)object).dimensions);
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DIMS_ID = new OptionID("distance.dims", "a comma separated array of integer values, where 0 <= d_i < the dimensionality of the feature space specifying the dimensions to be considered for distance computation. If this parameter is not set, no dimensions will be considered, i.e. the distance between two objects is always 0.");
        protected long[] dimensions = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntListParameter intListParameter = (IntListParameter)((IntListParameter)new IntListParameter(DIMS_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT_LIST)).setOptional(true);
            if (parameterization.grab(intListParameter)) {
                this.dimensions = intListParameter.getValueAsBitSet();
            }
        }
    }
}

