/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries.AbstractEditDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries.DTWDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Arrays;

@Title(value="Edit Distance on Real Sequence")
@Reference(authors="L. Chen and M. T. \u00d6zsu and V. Oria", title="Robust and fast similarity search for moving object trajectories", booktitle="SIGMOD '05: Proceedings of the 2005 ACM SIGMOD international conference on Management of data", url="http://dx.doi.org/10.1145/1066157.1066213")
public class EDRDistanceFunction
extends DTWDistanceFunction {
    private final double delta;

    public EDRDistanceFunction(double d, double d2) {
        super(d);
        this.delta = d2;
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n = numberVector.getDimensionality();
        int n2 = numberVector2.getDimensionality();
        int n3 = n2 - 1;
        int n4 = this.effectiveBandSize(n, n2);
        if (Math.abs(n - n2) > n4) {
            return Double.POSITIVE_INFINITY;
        }
        double[] dArray = new double[n2 << 1];
        Arrays.fill(dArray, Double.POSITIVE_INFINITY);
        this.firstRow(dArray, n4, numberVector, numberVector2, n2);
        int n5 = 0;
        int n6 = n2;
        int n7 = 1;
        int n8 = 0;
        int n9 = Math.min(n3, n7 + n4);
        while (n7 < n) {
            double d = numberVector.doubleValue(n7);
            for (int i = n8; i <= n9; ++i) {
                double d2 = dArray[n5 + i];
                if (i > 0) {
                    double d3 = dArray[n5 + i - 1];
                    double d4 = d2 = d3 < d2 ? d3 : d2;
                    if (i > n8) {
                        double d5 = dArray[n6 + i - 1];
                        d2 = d5 < d2 ? d5 : d2;
                    }
                }
                dArray[n6 + i] = d2 + this.delta(d, numberVector2.doubleValue(i));
            }
            n5 = n2 - n5;
            n6 = n2 - n6;
            if (++n7 > n4) {
                ++n8;
            }
            if (n9 >= n3) continue;
            ++n9;
        }
        return dArray[n5 + n2 - 1];
    }

    @Override
    protected void firstRow(double[] dArray, int n, NumberVector numberVector, NumberVector numberVector2, int n2) {
        double d = numberVector.doubleValue(0);
        dArray[0] = this.delta(d, numberVector2.doubleValue(0));
        int n3 = n >= n2 ? n2 - 1 : n;
        for (int i = 1; i <= n3; ++i) {
            dArray[i] = dArray[i - 1] + this.delta(d, numberVector2.doubleValue(i));
        }
    }

    @Override
    protected double delta(double d, double d2) {
        return Math.abs(d - d2) < this.delta ? 0.0 : 1.0;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        return this.delta == ((EDRDistanceFunction)object).delta;
    }

    public static class Parameterizer
    extends AbstractEditDistanceFunction.Parameterizer {
        public static final OptionID DELTA_ID = new OptionID("edr.delta", "the delta parameter (similarity threshold) for EDR (positive number)");
        protected double delta = 0.0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = (DoubleParameter)new DoubleParameter(DELTA_ID, 1.0).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.delta = doubleParameter.doubleValue();
            }
        }

        public static double getParameterDelta(Parameterization parameterization) {
            return 0.0;
        }

        @Override
        protected EDRDistanceFunction makeInstance() {
            return new EDRDistanceFunction(this.bandSize, this.delta);
        }
    }
}

