/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.model.ModelUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

public class EvaluateSquaredErrors
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateSquaredErrors.class);
    private NoiseHandling noiseOption;
    private NumberVectorDistanceFunction<?> distance;
    private String key = EvaluateSquaredErrors.class.getName();

    public EvaluateSquaredErrors(NumberVectorDistanceFunction<?> numberVectorDistanceFunction, NoiseHandling noiseHandling) {
        this.distance = numberVectorDistanceFunction;
        this.noiseOption = noiseHandling;
    }

    public double evaluateClustering(Database database, Relation<? extends NumberVector> relation, Clustering<?> clustering) {
        Object object;
        boolean bl = !(this.distance instanceof SquaredEuclideanDistanceFunction);
        int n = 0;
        List<Cluster<?>> list = clustering.getAllClusters();
        double d = 0.0;
        double d2 = 0.0;
        block4: for (Cluster<?> textWriteable2 : list) {
            if (textWriteable2.size() <= 1 || textWriteable2.isNoise()) {
                switch (this.noiseOption) {
                    case IGNORE_NOISE: {
                        n += textWriteable2.size();
                        continue block4;
                    }
                    case TREAT_NOISE_AS_SINGLETONS: {
                        continue block4;
                    }
                }
            }
            object = ModelUtil.getPrototypeOrCentroid(textWriteable2.getModel(), relation, textWriteable2.getIDs());
            DBIDIter dBIDIter = textWriteable2.getIDs().iter();
            while (dBIDIter.valid()) {
                double d3 = this.distance.distance((NumberVector)object, relation.get(dBIDIter));
                d2 += d3;
                d += bl ? d3 * d3 : d3;
                dBIDIter.advance();
            }
        }
        int n2 = Math.max(1, relation.size() - n);
        if (LOG.isStatistics()) {
            LOG.statistics(new DoubleStatistic(this.key + ".mean", d2 / (double)n2));
            LOG.statistics(new DoubleStatistic(this.key + ".ssq", d));
            LOG.statistics(new DoubleStatistic(this.key + ".rmsd", Math.sqrt(d / (double)n2)));
        }
        EvaluationResult evaluationResult = EvaluationResult.findOrCreate(database.getHierarchy(), clustering, "Internal Clustering Evaluation", "internal evaluation");
        object = evaluationResult.findOrCreateGroup("Distance-based Evaluation");
        ((EvaluationResult.MeasurementGroup)object).addMeasure("Mean distance", d2 / (double)n2, 0.0, Double.POSITIVE_INFINITY, true);
        ((EvaluationResult.MeasurementGroup)object).addMeasure("Sum of Squares", d, 0.0, Double.POSITIVE_INFINITY, true);
        ((EvaluationResult.MeasurementGroup)object).addMeasure("RMSD", Math.sqrt(d / (double)n2), 0.0, Double.POSITIVE_INFINITY, true);
        database.getHierarchy().add(clustering, evaluationResult);
        return d;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        List<Clustering<? extends Model>> list = ResultUtil.getClusteringResults(result);
        if (list.size() < 1) {
            return;
        }
        Database database = ResultUtil.findDatabase(resultHierarchy);
        Relation relation = database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        for (Clustering<? extends Model> clustering : list) {
            this.evaluateClustering(database, relation, clustering);
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("ssq.distance", "Distance function to use for computing the SSQ.");
        public static final OptionID NOISE_ID = new OptionID("ssq.noisehandling", "Control how noise should be treated.");
        private NumberVectorDistanceFunction<?> distance;
        private NoiseHandling noiseOption;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            EnumParameter<NoiseHandling> enumParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(DISTANCE_ID, (Class<?>)NumberVectorDistanceFunction.class, SquaredEuclideanDistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distance = (NumberVectorDistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(enumParameter = new EnumParameter<NoiseHandling>(NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS))) {
                this.noiseOption = (NoiseHandling)((Object)enumParameter.getValue());
            }
        }

        @Override
        protected EvaluateSquaredErrors makeInstance() {
            return new EvaluateSquaredErrors(this.distance, this.noiseOption);
        }
    }
}

