/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.icons;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class StockIcon {
    public static final String DIALOG_ERROR = "dialog-error";
    public static final String DIALOG_INFORMATION = "dialog-information";
    public static final String DIALOG_WARNING = "dialog-warning";
    public static final String DOCUMENT_OPEN = "document-open";
    public static final String DOCUMENT_PROPERTIES = "document-properties";
    public static final String DOCUMENT_SAVE = "document-save";
    public static final String EDIT_CLEAR = "edit-clear";
    public static final String EDIT_REDO = "edit-redo";
    public static final String EDIT_UNDO = "edit-undo";
    public static final String EDIT_FIND = "edit-find";
    public static final String EMBLEM_IMPORTANT = "emblem-important";
    public static final String GO_BOTTOM = "go-bottom";
    public static final String GO_DOWN = "go-down";
    public static final String GO_FIRST = "go-first";
    public static final String GO_HOME = "go-home";
    public static final String GO_JUMP = "go-jump";
    public static final String GO_LAST = "go-last";
    public static final String GO_NEXT = "go-next";
    public static final String GO_PREVIOUS = "go-previous";
    public static final String GO_TOP = "go-top";
    public static final String GO_UP = "go-up";
    public static final String HELP_BROWSER = "help-browser";
    public static final String LIST_ADD = "list-add";
    public static final String LIST_REMOVE = "list-remove";
    public static final String PACKAGE = "package";
    public static final String PROCESS_STOP = "process-stop";
    public static final String SYSTEM_SEARCH = "system-search";
    private static final Map<String, SoftReference<Icon>> iconcache = new HashMap<String, SoftReference<Icon>>();

    public static Icon getStockIcon(String string) {
        Object object;
        SoftReference<Icon> softReference = iconcache.get(string);
        if (softReference != null && (object = softReference.get()) != null) {
            return object;
        }
        object = StockIcon.class.getResource(string + ".png");
        if (object != null) {
            ImageIcon imageIcon = new ImageIcon((URL)object);
            iconcache.put(string, new SoftReference<ImageIcon>(imageIcon));
            return imageIcon;
        }
        LoggingUtil.warning("Could not find stock icon: " + string);
        return null;
    }
}

