/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.multistep.panels;

import de.lmu.ifi.dbs.elki.gui.multistep.MultiStepGUI;
import de.lmu.ifi.dbs.elki.gui.util.SavedSettingsFile;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.SerializedParameterization;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class SavedSettingsTabPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logging LOG = Logging.getLogger(SavedSettingsTabPanel.class);
    SavedSettingsFile store;
    SettingsComboboxModel savedSettingsModel;
    JComboBox<String> savedCombo;
    private MultiStepGUI gui;

    public SavedSettingsTabPanel(SavedSettingsFile savedSettingsFile, MultiStepGUI multiStepGUI) {
        this.store = savedSettingsFile;
        this.gui = multiStepGUI;
        this.setLayout(new GridBagLayout());
        this.savedSettingsModel = new SettingsComboboxModel(this.store);
        this.savedCombo = new JComboBox<String>(this.savedSettingsModel);
        this.savedCombo.setEditable(true);
        this.savedCombo.setSelectedItem("[Saved Settings]");
        Serializable serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 0.01;
        this.add(this.savedCombo, serializable);
        serializable = new JPanel();
        ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 0));
        JButton jButton = new JButton("Load");
        jButton.setMnemonic(76);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = SavedSettingsTabPanel.this.savedSettingsModel.getSelectedItem();
                ArrayList<String> arrayList = SavedSettingsTabPanel.this.store.get(string);
                SerializedParameterization serializedParameterization = new SerializedParameterization(arrayList);
                SavedSettingsTabPanel.this.gui.setParameters(serializedParameterization);
                serializedParameterization.logUnusedParameters();
                serializedParameterization.clearErrors();
            }
        });
        ((Container)serializable).add(jButton);
        JButton jButton2 = new JButton("Save");
        jButton2.setMnemonic(83);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = SavedSettingsTabPanel.this.savedSettingsModel.getSelectedItem();
                SavedSettingsTabPanel.this.store.put(string, SavedSettingsTabPanel.this.gui.serializeParameters());
                try {
                    SavedSettingsTabPanel.this.store.save();
                }
                catch (IOException iOException) {
                    LOG.exception(iOException);
                }
                SavedSettingsTabPanel.this.savedSettingsModel.update();
            }
        });
        ((Container)serializable).add(jButton2);
        JButton jButton3 = new JButton("Remove");
        jButton3.setMnemonic(69);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = SavedSettingsTabPanel.this.savedSettingsModel.getSelectedItem();
                SavedSettingsTabPanel.this.store.remove(string);
                try {
                    SavedSettingsTabPanel.this.store.save();
                }
                catch (IOException iOException) {
                    LOG.exception(iOException);
                }
                SavedSettingsTabPanel.this.savedCombo.setSelectedItem("[Saved Settings]");
                SavedSettingsTabPanel.this.savedSettingsModel.update();
            }
        });
        ((Container)serializable).add(jButton3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        this.add((Component)serializable, gridBagConstraints);
    }

    class SettingsComboboxModel
    extends AbstractListModel<String>
    implements ComboBoxModel<String> {
        private static final long serialVersionUID = 1L;
        protected SavedSettingsFile store;
        protected String selected = null;

        public SettingsComboboxModel(SavedSettingsFile savedSettingsFile) {
            this.store = savedSettingsFile;
        }

        @Override
        public String getSelectedItem() {
            return this.selected;
        }

        @Override
        public void setSelectedItem(Object object) {
            if (object instanceof String) {
                this.selected = (String)object;
            }
        }

        @Override
        public String getElementAt(int n) {
            return (String)this.store.getElementAt((int)(this.store.size() - 1 - n)).first;
        }

        @Override
        public int getSize() {
            return this.store.size();
        }

        public void update() {
            this.fireContentsChanged(this, 0, this.getSize() + 1);
        }
    }
}

