/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.DynamicIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.KNNChangeEvent;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.KNNListener;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.List;
import javax.swing.event.EventListenerList;

@Title(value="Materialize kNN Neighborhood preprocessor")
@Description(value="Materializes the k nearest neighbors of objects of a database.")
@Alias(value={"de.lmu.ifi.dbs.elki.preprocessing.MaterializeKNNPreprocessor"})
public class MaterializeKNNPreprocessor<O>
extends AbstractMaterializeKNNPreprocessor<O>
implements DynamicIndex {
    private static final Logging LOG = Logging.getLogger(MaterializeKNNPreprocessor.class);
    private static final boolean usebulk = false;
    protected final KNNQuery<O> knnQuery;
    protected final EventListenerList listenerList = new EventListenerList();

    public MaterializeKNNPreprocessor(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int n) {
        super(relation, distanceFunction, n);
        this.knnQuery = relation.getKNNQuery(this.distanceQuery, n, "need_bulk", "heavy", "no-cache");
    }

    @Override
    protected void preprocess() {
        Logging logging = this.getLogger();
        this.createStorage();
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(this.relation.getDBIDs());
        if (logging.isStatistics()) {
            logging.statistics(new LongStatistic(this.getClass().getName() + ".k", this.k));
        }
        Duration duration = logging.isStatistics() ? logging.newDuration(this.getClass().getName() + ".precomputation-time").begin() : null;
        FiniteProgress finiteProgress = this.getLogger().isVerbose() ? new FiniteProgress("Materializing k nearest neighbors (k=" + this.k + ")", arrayDBIDs.size(), this.getLogger()) : null;
        Object var5_5 = null;
        boolean bl = this.getDistanceQuery().getDistanceFunction().isMetric();
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        while (dBIDArrayIter.valid()) {
            if (bl && this.storage.get(dBIDArrayIter) != null) {
                logging.incrementProcessed(finiteProgress);
            } else {
                KNNList kNNList = this.knnQuery.getKNNForDBID(dBIDArrayIter, this.k);
                this.storage.put(dBIDArrayIter, kNNList);
                if (bl) {
                    DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
                    while (doubleDBIDListIter.valid() && doubleDBIDListIter.doubleValue() == 0.0) {
                        this.storage.put(doubleDBIDListIter, kNNList);
                        doubleDBIDListIter.advance();
                    }
                }
                logging.incrementProcessed(finiteProgress);
            }
            dBIDArrayIter.advance();
        }
        logging.ensureCompleted(finiteProgress);
        if (duration != null) {
            logging.statistics(duration.end());
        }
    }

    @Override
    public final void insert(DBIDRef dBIDRef) {
        this.objectsInserted(DBIDUtil.deref(dBIDRef));
    }

    @Override
    public void insertAll(DBIDs dBIDs) {
        if (this.storage == null && dBIDs.size() > 0) {
            this.preprocess();
        } else {
            this.objectsInserted(dBIDs);
        }
    }

    @Override
    public boolean delete(DBIDRef dBIDRef) {
        this.objectsRemoved(DBIDUtil.deref(dBIDRef));
        return true;
    }

    @Override
    public void deleteAll(DBIDs dBIDs) {
        this.objectsRemoved(dBIDs);
    }

    protected void objectsInserted(DBIDs dBIDs) {
        Logging logging = this.getLogger();
        StepProgress stepProgress = logging.isVerbose() ? new StepProgress(3) : null;
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(dBIDs);
        logging.beginStep(stepProgress, 1, "New insertions ocurred, materialize their new kNNs.");
        List<KNNList> list = this.knnQuery.getKNNForBulkDBIDs(arrayDBIDs, this.k);
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        for (int i = 0; i < arrayDBIDs.size(); ++i) {
            this.storage.put(dBIDArrayIter, list.get(i));
            dBIDArrayIter.advance();
        }
        logging.beginStep(stepProgress, 2, "New insertions ocurred, update the affected kNNs.");
        ArrayDBIDs arrayDBIDs2 = this.updateKNNsAfterInsertion(dBIDs);
        logging.beginStep(stepProgress, 3, "New insertions ocurred, inform listeners.");
        this.fireKNNsInserted(dBIDs, arrayDBIDs2);
        logging.setCompleted(stepProgress);
    }

    private ArrayDBIDs updateKNNsAfterInsertion(DBIDs dBIDs) {
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
        ModifiableDBIDs modifiableDBIDs = DBIDUtil.difference(this.relation.getDBIDs(), dBIDs);
        DBIDIter dBIDIter = modifiableDBIDs.iter();
        while (dBIDIter.valid()) {
            KNNList kNNList = (KNNList)this.storage.get(dBIDIter);
            double d = kNNList.getKNNDistance();
            KNNHeap kNNHeap = null;
            DBIDIter dBIDIter2 = dBIDs.iter();
            while (dBIDIter2.valid()) {
                double d2 = this.distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)dBIDIter2);
                if (d2 <= d) {
                    if (kNNHeap == null) {
                        kNNHeap = DBIDUtil.newHeap(kNNList);
                    }
                    kNNHeap.insert(d2, dBIDIter2);
                }
                dBIDIter2.advance();
            }
            if (kNNHeap != null) {
                kNNList = kNNHeap.toKNNList();
                this.storage.put(dBIDIter, kNNList);
                arrayModifiableDBIDs.add(dBIDIter);
            }
            dBIDIter.advance();
        }
        return arrayModifiableDBIDs;
    }

    private ArrayDBIDs updateKNNsAfterDeletion(DBIDs dBIDs) {
        Object object;
        SetDBIDs setDBIDs = DBIDUtil.ensureSet(dBIDs);
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
        Object object2 = this.relation.iterDBIDs();
        while (object2.valid()) {
            object = (KNNList)this.storage.get((DBIDRef)object2);
            DoubleDBIDListIter doubleDBIDListIter = object.iter();
            while (doubleDBIDListIter.valid()) {
                if (setDBIDs.contains(doubleDBIDListIter)) {
                    arrayModifiableDBIDs.add((DBIDRef)object2);
                    break;
                }
                doubleDBIDListIter.advance();
            }
            object2.advance();
        }
        object2 = this.knnQuery.getKNNForBulkDBIDs(arrayModifiableDBIDs, this.k);
        object = arrayModifiableDBIDs.iter();
        for (int i = 0; i < arrayModifiableDBIDs.size(); ++i) {
            this.storage.put((DBIDRef)object, object2.get(i));
            object.advance();
        }
        return arrayModifiableDBIDs;
    }

    protected void objectsRemoved(DBIDs dBIDs) {
        Logging logging = this.getLogger();
        StepProgress stepProgress = logging.isVerbose() ? new StepProgress(3) : null;
        logging.beginStep(stepProgress, 1, "New deletions ocurred, remove their materialized kNNs.");
        Object object = dBIDs.iter();
        while (object.valid()) {
            this.storage.delete((DBIDRef)object);
            object.advance();
        }
        logging.beginStep(stepProgress, 2, "New deletions ocurred, update the affected kNNs.");
        object = this.updateKNNsAfterDeletion(dBIDs);
        logging.beginStep(stepProgress, 3, "New deletions ocurred, inform listeners.");
        this.fireKNNsRemoved(dBIDs, (DBIDs)object);
        logging.ensureCompleted(stepProgress);
    }

    protected void fireKNNsInserted(DBIDs dBIDs, DBIDs dBIDs2) {
        KNNChangeEvent kNNChangeEvent = new KNNChangeEvent(this, KNNChangeEvent.Type.INSERT, dBIDs, dBIDs2);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != KNNListener.class) continue;
            ((KNNListener)objectArray[i + 1]).kNNsChanged(kNNChangeEvent);
        }
    }

    protected void fireKNNsRemoved(DBIDs dBIDs, DBIDs dBIDs2) {
        KNNChangeEvent kNNChangeEvent = new KNNChangeEvent(this, KNNChangeEvent.Type.DELETE, dBIDs, dBIDs2);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != KNNListener.class) continue;
            ((KNNListener)objectArray[i + 1]).kNNsChanged(kNNChangeEvent);
        }
    }

    public void addKNNListener(KNNListener kNNListener) {
        this.listenerList.add(KNNListener.class, kNNListener);
    }

    public void removeKNNListener(KNNListener kNNListener) {
        this.listenerList.remove(KNNListener.class, kNNListener);
    }

    @Override
    public String getLongName() {
        return "kNN Preprocessor";
    }

    @Override
    public String getShortName() {
        return "knn preprocessor";
    }

    @Override
    public void logStatistics() {
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Factory<O>
    extends AbstractMaterializeKNNPreprocessor.Factory<O> {
        public Factory(int n, DistanceFunction<? super O> distanceFunction) {
            super(n, distanceFunction);
        }

        @Override
        public MaterializeKNNPreprocessor<O> instantiate(Relation<O> relation) {
            MaterializeKNNPreprocessor<O> materializeKNNPreprocessor = new MaterializeKNNPreprocessor<O>(relation, this.distanceFunction, this.k);
            return materializeKNNPreprocessor;
        }

        public static class Parameterizer<O>
        extends AbstractMaterializeKNNPreprocessor.Factory.Parameterizer<O> {
            @Override
            protected Factory<O> makeInstance() {
                return new Factory(this.k, this.distanceFunction);
            }
        }
    }
}

