/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.localpca;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.AbstractPreprocessorIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.localpca.FilteredLocalPCAIndex;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredRunner;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="Local PCA Preprocessor")
@Description(value="Materializes the local PCA and the locally weighted matrix of objects of a database.")
public abstract class AbstractFilteredPCAIndex<NV extends NumberVector>
extends AbstractPreprocessorIndex<NV, PCAFilteredResult>
implements FilteredLocalPCAIndex<NV> {
    protected final PCAFilteredRunner pca;

    public AbstractFilteredPCAIndex(Relation<NV> relation, PCAFilteredRunner pCAFilteredRunner) {
        super(relation);
        this.pca = pCAFilteredRunner;
    }

    @Override
    public void initialize() {
        if (this.relation == null || this.relation.size() <= 0) {
            throw new IllegalArgumentException("database empty: must contain elements");
        }
        if (this.storage != null) {
            return;
        }
        this.storage = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 3, PCAFilteredResult.class);
        long l = System.currentTimeMillis();
        FiniteProgress finiteProgress = this.getLogger().isVerbose() ? new FiniteProgress("Performing local PCA", this.relation.size(), this.getLogger()) : null;
        DBIDIter dBIDIter = this.relation.iterDBIDs();
        while (dBIDIter.valid()) {
            DoubleDBIDList doubleDBIDList = this.objectsForPCA(dBIDIter);
            PCAResult pCAResult = this.pca.processQueryResult(doubleDBIDList, this.relation);
            this.storage.put(dBIDIter, pCAResult);
            this.getLogger().incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        this.getLogger().ensureCompleted(finiteProgress);
        long l2 = System.currentTimeMillis();
        if (this.getLogger().isVerbose()) {
            long l3 = l2 - l;
            this.getLogger().verbose(this.getClass().getName() + " runtime: " + l3 + " milliseconds.");
        }
    }

    @Override
    public PCAFilteredResult getLocalProjection(DBIDRef dBIDRef) {
        if (this.storage == null) {
            this.initialize();
        }
        return (PCAFilteredResult)this.storage.get(dBIDRef);
    }

    protected abstract DoubleDBIDList objectsForPCA(DBIDRef var1);

    public static abstract class Factory<NV extends NumberVector, I extends AbstractFilteredPCAIndex<NV>>
    implements FilteredLocalPCAIndex.Factory<NV, I> {
        public static final OptionID PCA_DISTANCE_ID = new OptionID("localpca.distancefunction", "The distance function used to select objects for running PCA.");
        protected DistanceFunction<NV> pcaDistanceFunction;
        protected PCAFilteredRunner pca;

        public Factory(DistanceFunction<NV> distanceFunction, PCAFilteredRunner pCAFilteredRunner) {
            this.pcaDistanceFunction = distanceFunction;
            this.pca = pCAFilteredRunner;
        }

        @Override
        public abstract I instantiate(Relation<NV> var1);

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.pcaDistanceFunction.getInputTypeRestriction();
        }

        public static abstract class Parameterizer<NV extends NumberVector, I extends AbstractFilteredPCAIndex<NV>>
        extends AbstractParameterizer {
            protected DistanceFunction<NV> pcaDistanceFunction;
            protected PCAFilteredRunner pca;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                super.makeOptions(parameterization);
                ObjectParameter objectParameter = new ObjectParameter(PCA_DISTANCE_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class);
                if (parameterization.grab(objectParameter)) {
                    this.pcaDistanceFunction = (DistanceFunction)objectParameter.instantiateClass(parameterization);
                }
                Class clazz = ClassGenericsUtil.uglyCastIntoSubclass(PCAFilteredRunner.class);
                this.pca = (PCAFilteredRunner)parameterization.tryInstantiate(clazz);
            }
        }
    }
}

