/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree;

import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.Node;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.persistent.AbstractExternalizablePage;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class AbstractNode<E extends Entry>
extends AbstractExternalizablePage
implements Node<E> {
    protected int numEntries;
    protected E[] entries;
    protected boolean isLeaf;

    public AbstractNode() {
    }

    public AbstractNode(int n, boolean bl, Class<? super E> clazz) {
        this.numEntries = 0;
        Class clazz2 = ClassGenericsUtil.uglyCastIntoSubclass(clazz);
        this.entries = (Entry[])ClassGenericsUtil.newArrayOfNull(n, clazz2);
        this.isLeaf = bl;
    }

    @Override
    public final Enumeration<IndexTreePath<E>> children(final IndexTreePath<E> indexTreePath) {
        return new Enumeration<IndexTreePath<E>>(){
            int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count < AbstractNode.this.numEntries;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IndexTreePath<E> nextElement() {
                AbstractNode abstractNode = AbstractNode.this;
                synchronized (abstractNode) {
                    if (this.count < AbstractNode.this.numEntries) {
                        return new IndexTreePath(indexTreePath, AbstractNode.this.entries[this.count], this.count++);
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public final int getNumEntries() {
        return this.numEntries;
    }

    @Override
    public final boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public final E getEntry(int n) {
        return this.entries[n];
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeBoolean(this.isLeaf);
        objectOutput.writeInt(this.numEntries);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.isLeaf = objectInput.readBoolean();
        this.numEntries = objectInput.readInt();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractNode abstractNode = (AbstractNode)object;
        return this.isLeaf == abstractNode.isLeaf && this.numEntries == abstractNode.numEntries && Arrays.equals(this.entries, abstractNode.entries);
    }

    @Override
    public final String toString() {
        if (this.isLeaf) {
            return "LeafNode " + this.getPageID();
        }
        return "DirNode " + this.getPageID();
    }

    @Override
    public final int addLeafEntry(E e) {
        if (!e.isLeafEntry()) {
            throw new UnsupportedOperationException("Entry is not a leaf entry!");
        }
        if (!this.isLeaf()) {
            throw new UnsupportedOperationException("Node is not a leaf node!");
        }
        return this.addEntry(e);
    }

    @Override
    public final int addDirectoryEntry(E e) {
        if (e.isLeafEntry()) {
            throw new UnsupportedOperationException("Entry is not a directory entry!");
        }
        if (this.isLeaf()) {
            throw new UnsupportedOperationException("Node is not a directory node!");
        }
        return this.addEntry(e);
    }

    public boolean deleteEntry(int n) {
        System.arraycopy(this.entries, n + 1, this.entries, n, this.numEntries - n - 1);
        this.entries[--this.numEntries] = null;
        return true;
    }

    public final void deleteAllEntries() {
        if (this.numEntries > 0) {
            Arrays.fill(this.entries, null);
            this.numEntries = 0;
        }
    }

    public final int getCapacity() {
        return this.entries.length;
    }

    @Deprecated
    public final List<E> getEntries() {
        ArrayList<E> arrayList = new ArrayList<E>(this.numEntries);
        for (E e : this.entries) {
            if (e == null) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    private int addEntry(E e) {
        this.entries[this.numEntries++] = e;
        return this.numEntries - 1;
    }

    public void removeMask(long[] lArray) {
        int n;
        int n2 = BitsUtil.nextSetBit(lArray, 0);
        if (n2 < 0) {
            return;
        }
        for (n = BitsUtil.nextSetBit(lArray, n2); n < this.numEntries; ++n) {
            if (BitsUtil.get(lArray, n)) continue;
            this.entries[n2] = this.entries[n];
            ++n2;
        }
        int n3 = n - n2;
        while (n2 < this.numEntries) {
            this.entries[n2] = null;
            ++n2;
        }
        this.numEntries -= n3;
    }

    public final void splitTo(AbstractNode<E> abstractNode, List<E> list, int n) {
        int n2;
        assert (this.isLeaf() == abstractNode.isLeaf());
        this.deleteAllEntries();
        StringBuilder stringBuilder = LoggingConfiguration.DEBUG ? new StringBuilder("\n") : null;
        for (n2 = 0; n2 < n; ++n2) {
            this.addEntry((Entry)list.get(n2));
            if (stringBuilder == null) continue;
            stringBuilder.append("n_").append(this.getPageID()).append(" ");
            stringBuilder.append(list.get(n2)).append("\n");
        }
        for (n2 = n; n2 < list.size(); ++n2) {
            super.addEntry((Entry)list.get(n2));
            if (stringBuilder == null) continue;
            stringBuilder.append("n_").append(abstractNode.getPageID()).append(" ");
            stringBuilder.append(list.get(n2)).append("\n");
        }
        if (stringBuilder != null) {
            Logging.getLogger(this.getClass().getName()).fine(stringBuilder.toString());
        }
    }

    public final void splitTo(AbstractNode<E> abstractNode, List<E> list, List<E> list2) {
        assert (this.isLeaf() == abstractNode.isLeaf());
        this.deleteAllEntries();
        StringBuilder stringBuilder = LoggingConfiguration.DEBUG ? new StringBuilder() : null;
        for (Entry entry : list) {
            if (stringBuilder != null) {
                stringBuilder.append("n_").append(this.getPageID()).append(" ").append(entry).append("\n");
            }
            this.addEntry(entry);
        }
        for (Entry entry : list2) {
            if (stringBuilder != null) {
                stringBuilder.append("n_").append(abstractNode.getPageID()).append(" ").append(entry).append("\n");
            }
            super.addEntry(entry);
        }
        if (stringBuilder != null) {
            Logging.getLogger(this.getClass()).fine(stringBuilder.toString());
        }
    }

    public final void splitByMask(AbstractNode<E> abstractNode, long[] lArray) {
        assert (this.isLeaf() == abstractNode.isLeaf());
        int n = BitsUtil.nextSetBit(lArray, 0);
        if (n < 0) {
            throw new AbortException("No bits set in splitting mask.");
        }
        for (int i = n; i < this.numEntries; ++i) {
            if (BitsUtil.get(lArray, i)) {
                super.addEntry(this.entries[i]);
                continue;
            }
            this.entries[n] = this.entries[i];
            ++n;
        }
        int n2 = this.numEntries - n;
        while (n < this.numEntries) {
            this.entries[n] = null;
            ++n;
        }
        this.numEntries -= n2;
    }
}

