/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.covertree;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.AbstractDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.metrical.covertree.AbstractCoverTree;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleObjectMinHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.ArrayList;

@Reference(authors="A. Beygelzimer, S. Kakade, J. Langford", title="Cover trees for nearest neighbor", booktitle="In Proc. 23rd International Conference on Machine Learning (ICML)", url="http://dx.doi.org/10.1145/1143844.1143857")
public class CoverTree<O>
extends AbstractCoverTree<O>
implements RangeIndex<O>,
KNNIndex<O> {
    static final Logging LOG = Logging.getLogger(CoverTree.class);
    private Node root = null;

    public CoverTree(Relation<O> relation, DistanceFunction<? super O> distanceFunction, double d, int n) {
        super(relation, distanceFunction, d, n);
    }

    @Override
    public void initialize() {
        this.bulkLoad(this.relation.getDBIDs());
        if (LOG.isVerbose()) {
            int[] nArray = new int[5];
            this.checkCoverTree(this.root, nArray, 0);
            LOG.statistics(new LongStatistic(this.getClass().getName() + ".nodes", nArray[0]));
            LOG.statistics(new DoubleStatistic(this.getClass().getName() + ".avg-depth", (double)nArray[1] / (double)nArray[0]));
            LOG.statistics(new LongStatistic(this.getClass().getName() + ".max-depth", nArray[2]));
            LOG.statistics(new LongStatistic(this.getClass().getName() + ".singletons", nArray[3]));
            LOG.statistics(new LongStatistic(this.getClass().getName() + ".entries", nArray[4]));
        }
    }

    public void bulkLoad(DBIDs dBIDs) {
        if (dBIDs.size() == 0) {
            return;
        }
        assert (this.root == null) : "Tree already initialized.";
        DBIDIter dBIDIter = dBIDs.iter();
        DBID dBID = DBIDUtil.deref(dBIDIter);
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList(dBIDs.size() - 1);
        dBIDIter.advance();
        while (dBIDIter.valid()) {
            modifiableDoubleDBIDList.add(this.distance(dBID, (DBIDRef)dBIDIter), dBIDIter);
            dBIDIter.advance();
        }
        this.root = this.bulkConstruct(dBID, Integer.MAX_VALUE, 0.0, modifiableDoubleDBIDList);
    }

    protected Node bulkConstruct(DBIDRef dBIDRef, int n, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        boolean bl;
        assert (!modifiableDoubleDBIDList.contains(dBIDRef));
        double d2 = this.maxDistance(modifiableDoubleDBIDList);
        int n2 = Math.min(this.distToScale(d2) - 1, n);
        int n3 = n2 - 1;
        if (d2 <= 0.0 || n2 <= this.scaleBottom || modifiableDoubleDBIDList.size() < this.truncate) {
            return new Node(dBIDRef, d2, d, modifiableDoubleDBIDList);
        }
        ModifiableDoubleDBIDList modifiableDoubleDBIDList2 = DBIDUtil.newDistanceDBIDList();
        this.excludeNotCovered(modifiableDoubleDBIDList, this.scaleToDist(n2), modifiableDoubleDBIDList2);
        if (modifiableDoubleDBIDList2.size() == 0) {
            LOG.warning("Scale not chosen appropriately? " + d2 + " " + this.scaleToDist(n2));
            return this.bulkConstruct(dBIDRef, n3, d, modifiableDoubleDBIDList);
        }
        Node node = new Node(dBIDRef, d2, d);
        boolean bl2 = bl = modifiableDoubleDBIDList.size() == 0;
        if (!bl) {
            node.children.add(this.bulkConstruct(dBIDRef, n3, 0.0, modifiableDoubleDBIDList));
        }
        double d3 = this.scaleToDist(n3);
        DoubleDBIDListMIter doubleDBIDListMIter = modifiableDoubleDBIDList2.iter();
        while (doubleDBIDListMIter.valid()) {
            assert (doubleDBIDListMIter.getOffset() == 0);
            DBID dBID = DBIDUtil.deref(doubleDBIDListMIter);
            modifiableDoubleDBIDList.clear();
            this.collectByCover(doubleDBIDListMIter, modifiableDoubleDBIDList2, d3, modifiableDoubleDBIDList);
            assert (DBIDUtil.equal(dBID, doubleDBIDListMIter)) : "First element in candidates must not change!";
            if (modifiableDoubleDBIDList.size() == 0) {
                node.singletons.add(doubleDBIDListMIter.doubleValue(), doubleDBIDListMIter);
            } else {
                node.children.add(this.bulkConstruct(doubleDBIDListMIter, n3, doubleDBIDListMIter.doubleValue(), modifiableDoubleDBIDList));
            }
            modifiableDoubleDBIDList2.removeSwap(0);
        }
        assert (modifiableDoubleDBIDList2.size() == 0);
        if (bl) {
            if (node.isLeaf()) {
                node.children = null;
            } else {
                node.singletons.add(d, dBIDRef);
            }
        }
        return node;
    }

    private void checkCoverTree(Node node, int[] nArray, int n) {
        nArray[0] = nArray[0] + 1;
        nArray[1] = nArray[1] + n;
        nArray[2] = n > nArray[2] ? n : nArray[2];
        nArray[3] = nArray[3] + (node.singletons.size() - 1);
        nArray[4] = nArray[4] + (node.singletons.size() - (node.children == null ? 0 : 1));
        if (node.children != null) {
            ++n;
            for (Node node2 : node.children) {
                this.checkCoverTree(node2, nArray, n);
            }
            assert (node.children.size() > 0) : "Empty childs list.";
        }
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.distanceFunction.equals(distanceFunction)) {
            LOG.debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        DistanceQuery distanceQuery2 = distanceFunction.instantiate(this.relation);
        return new CoverTreeRangeQuery(distanceQuery2);
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.distanceFunction.equals(distanceFunction)) {
            LOG.debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        DistanceQuery distanceQuery2 = distanceFunction.instantiate(this.relation);
        return new CoverTreeKNNQuery(distanceQuery2);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Factory<O>
    extends AbstractCoverTree.Factory<O, CoverTree<O>> {
        public Factory(DistanceFunction<? super O> distanceFunction, double d, int n) {
            super(distanceFunction, d, n);
        }

        @Override
        public CoverTree<O> instantiate(Relation<O> relation) {
            return new CoverTree<O>(relation, this.distanceFunction, this.expansion, this.truncate);
        }

        public static class Parameterizer<O>
        extends AbstractCoverTree.Factory.Parameterizer<O> {
            @Override
            protected Factory<O> makeInstance() {
                return new Factory(this.distanceFunction, this.expansion, this.truncate);
            }
        }
    }

    public class CoverTreeKNNQuery
    extends AbstractDistanceKNNQuery<O>
    implements KNNQuery<O> {
        public CoverTreeKNNQuery(DistanceQuery<O> distanceQuery) {
            super(distanceQuery);
        }

        @Override
        public KNNList getKNNForObject(O o, int n) {
            if (n < 1) {
                throw new IllegalArgumentException("At least one object has to be requested!");
            }
            KNNHeap kNNHeap = DBIDUtil.newHeap(n);
            double d = Double.POSITIVE_INFINITY;
            DoubleObjectMinHeap<Node> doubleObjectMinHeap = new DoubleObjectMinHeap<Node>();
            double d2 = CoverTree.this.distance(o, (DBIDRef)((CoverTree)CoverTree.this).root.singletons.iter());
            doubleObjectMinHeap.add(d2 - ((CoverTree)CoverTree.this).root.maxDist, CoverTree.this.root);
            while (!doubleObjectMinHeap.isEmpty()) {
                Node node = (Node)doubleObjectMinHeap.peekValue();
                double d3 = doubleObjectMinHeap.peekKey();
                double d4 = d3 + node.maxDist;
                doubleObjectMinHeap.poll();
                if (kNNHeap.size() >= n && d3 > d) continue;
                DoubleDBIDListMIter doubleDBIDListMIter = node.singletons.iter();
                if (!node.isLeaf()) {
                    for (Node node2 : node.children) {
                        if (!(d4 - node2.maxDist - node2.parentDist <= d)) continue;
                        DoubleDBIDListMIter doubleDBIDListMIter2 = node2.singletons.iter();
                        double d5 = DBIDUtil.equal(doubleDBIDListMIter2, doubleDBIDListMIter) ? d4 : CoverTree.this.distance(o, (DBIDRef)doubleDBIDListMIter2);
                        double d6 = d5;
                        double d7 = d6 - node2.maxDist;
                        if (!(d7 <= d)) continue;
                        doubleObjectMinHeap.add(d7, node2);
                    }
                } else if (d4 <= d) {
                    d = kNNHeap.insert(d4, doubleDBIDListMIter);
                }
                doubleDBIDListMIter.advance();
                while (doubleDBIDListMIter.valid()) {
                    double d8;
                    if (d4 - doubleDBIDListMIter.doubleValue() <= d && (d8 = CoverTree.this.distance(o, (DBIDRef)doubleDBIDListMIter)) <= d) {
                        d = kNNHeap.insert(d8, doubleDBIDListMIter);
                    }
                    doubleDBIDListMIter.advance();
                }
            }
            return kNNHeap.toKNNList();
        }
    }

    public class CoverTreeRangeQuery
    extends AbstractDistanceRangeQuery<O>
    implements RangeQuery<O> {
        public CoverTreeRangeQuery(DistanceQuery<O> distanceQuery) {
            super(distanceQuery);
        }

        @Override
        public void getRangeForObject(O o, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            arrayList.add(CoverTree.this.root);
            while (!arrayList.isEmpty()) {
                Node node = (Node)arrayList.remove(arrayList.size() - 1);
                DoubleDBIDListMIter doubleDBIDListMIter = node.singletons.iter();
                double d2 = CoverTree.this.distance(o, (DBIDRef)doubleDBIDListMIter);
                if (d2 - node.maxDist > d) continue;
                if (!node.isLeaf()) {
                    for (Node node2 : node.children) {
                        if (!(d2 - node2.maxDist - node2.parentDist <= d)) continue;
                        arrayList.add(node2);
                    }
                } else if (d2 <= d) {
                    modifiableDoubleDBIDList.add(d2, doubleDBIDListMIter);
                }
                doubleDBIDListMIter.advance();
                while (doubleDBIDListMIter.valid()) {
                    double d3;
                    if (d2 - doubleDBIDListMIter.doubleValue() <= d && (d3 = CoverTree.this.distance(o, (DBIDRef)doubleDBIDListMIter)) <= d) {
                        modifiableDoubleDBIDList.add(d3, doubleDBIDListMIter);
                    }
                    doubleDBIDListMIter.advance();
                }
            }
        }
    }

    private static final class Node {
        ModifiableDoubleDBIDList singletons;
        double maxDist = 0.0;
        double parentDist = 0.0;
        ArrayList<Node> children;

        public Node(DBIDRef dBIDRef, double d, double d2) {
            this.singletons = DBIDUtil.newDistanceDBIDList();
            this.singletons.add(0.0, dBIDRef);
            this.children = new ArrayList();
            this.maxDist = d;
            this.parentDist = d2;
        }

        public Node(DBIDRef dBIDRef, double d, double d2, DoubleDBIDList doubleDBIDList) {
            assert (!doubleDBIDList.contains(dBIDRef));
            this.singletons = DBIDUtil.newDistanceDBIDList(doubleDBIDList.size() + 1);
            this.singletons.add(0.0, dBIDRef);
            DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
            while (doubleDBIDListIter.valid()) {
                this.singletons.add(doubleDBIDListIter.doubleValue(), doubleDBIDListIter);
                doubleDBIDListIter.advance();
            }
            this.children = null;
            this.maxDist = d;
            this.parentDist = d2;
        }

        public boolean isLeaf() {
            return this.children == null || this.children.size() == 0;
        }
    }
}

