/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MTreeQueryUtil;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractMkTree<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry, S extends MTreeSettings<O, N, E>>
extends AbstractMTree<O, N, E, S> {
    protected KNNQuery<O> knnq;
    private DistanceQuery<O> distanceQuery;

    public AbstractMkTree(Relation<O> relation, PageFile<N> pageFile, S s) {
        super(pageFile, s);
        this.distanceQuery = this.getDistanceFunction().instantiate(relation);
        this.knnq = MTreeQueryUtil.getKNNQuery(this, this.distanceQuery, new Object[0]);
    }

    @Override
    public double distance(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        if (dBIDRef == null || dBIDRef2 == null) {
            return Double.NaN;
        }
        if (DBIDUtil.equal(dBIDRef, dBIDRef2)) {
            return 0.0;
        }
        this.statistics.countDistanceCalculation();
        return this.distanceQuery.distance(dBIDRef, dBIDRef2);
    }

    public abstract DoubleDBIDList reverseKNNQuery(DBIDRef var1, int var2);

    @Deprecated
    protected final Map<DBID, KNNList> batchNN(N n, DBIDs dBIDs, int n2) {
        HashMap<DBID, KNNList> hashMap = new HashMap<DBID, KNNList>(dBIDs.size());
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            DBID dBID = DBIDUtil.deref(dBIDIter);
            hashMap.put(dBID, this.knnq.getKNNForDBID(dBID, n2));
            dBIDIter.advance();
        }
        return hashMap;
    }
}

