/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants;

import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRTreeSettings;
import de.lmu.ifi.dbs.elki.persistent.AbstractExternalizablePage;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.ArrayList;
import java.util.List;

public abstract class NonFlatRStarTree<N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry, S extends AbstractRTreeSettings>
extends AbstractRStarTree<N, E, S> {
    public NonFlatRStarTree(PageFile<N> pageFile, S s) {
        super(pageFile, s);
    }

    @Override
    protected boolean hasOverflow(N n) {
        if (((AbstractNode)n).isLeaf()) {
            return ((AbstractNode)n).getNumEntries() == this.leafCapacity;
        }
        return ((AbstractNode)n).getNumEntries() == this.dirCapacity;
    }

    @Override
    protected boolean hasUnderflow(N n) {
        if (((AbstractNode)n).isLeaf()) {
            return ((AbstractNode)n).getNumEntries() < this.leafMinimum;
        }
        return ((AbstractNode)n).getNumEntries() < this.dirMinimum;
    }

    @Override
    protected int computeHeight() {
        AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.getRoot();
        int n = 1;
        while (!abstractRStarTreeNode.isLeaf() && abstractRStarTreeNode.getNumEntries() != 0) {
            SpatialEntry spatialEntry = (SpatialEntry)abstractRStarTreeNode.getEntry(0);
            abstractRStarTreeNode = (AbstractRStarTreeNode)this.getNode(spatialEntry);
            ++n;
        }
        return n;
    }

    @Override
    protected void createEmptyRoot(E e) {
        AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.createNewLeafNode();
        this.writeNode(abstractRStarTreeNode);
        this.setHeight(1);
    }

    @Override
    protected void bulkLoad(List<E> list) {
        StringBuilder stringBuilder;
        if (!this.initialized) {
            this.initialize((Entry)list.get(0));
        }
        StringBuilder stringBuilder2 = stringBuilder = this.getLogger().isDebuggingFine() ? new StringBuilder() : null;
        if (list.size() <= this.leafCapacity) {
            AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.createNewLeafNode();
            abstractRStarTreeNode.setPageID(this.getRootID());
            this.writeNode(abstractRStarTreeNode);
            this.createRoot(abstractRStarTreeNode, list);
            this.setHeight(1);
            if (stringBuilder != null) {
                stringBuilder.append("\n  numNodes = 1");
            }
        } else {
            AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.createNewDirectoryNode();
            abstractRStarTreeNode.setPageID(this.getRootID());
            this.writeNode(abstractRStarTreeNode);
            List<E> list2 = this.createBulkLeafNodes(list);
            int n = list2.size();
            if (stringBuilder != null) {
                stringBuilder.append("\n  numLeafNodes = ").append(n);
            }
            this.setHeight(1);
            while (list2.size() > this.dirCapacity - 1) {
                list2 = this.createBulkDirectoryNodes(list2);
                n += list2.size();
                this.setHeight(this.getHeight() + 1);
            }
            this.createRoot(abstractRStarTreeNode, list2);
            ++n;
            this.setHeight(this.getHeight() + 1);
            if (stringBuilder != null) {
                stringBuilder.append("\n  numNodes = ").append(n);
            }
        }
        if (stringBuilder != null) {
            stringBuilder.append("\n  height = ").append(this.getHeight());
            stringBuilder.append("\n  root ").append(this.getRoot());
            this.getLogger().debugFine(stringBuilder.toString());
        }
    }

    private List<E> createBulkDirectoryNodes(List<E> list) {
        int n = this.dirMinimum;
        int n2 = this.dirCapacity - 1;
        ArrayList arrayList = new ArrayList();
        List<List<E>> list2 = this.settings.bulkSplitter.partition(list, n, n2);
        for (List<E> list3 : list2) {
            AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.createNewDirectoryNode();
            for (SpatialEntry spatialEntry : list3) {
                abstractRStarTreeNode.addDirectoryEntry(spatialEntry);
            }
            this.writeNode(abstractRStarTreeNode);
            arrayList.add(this.createNewDirectoryEntry(abstractRStarTreeNode));
            if (!this.getLogger().isDebuggingFiner()) continue;
            this.getLogger().debugFiner("Directory page no: " + abstractRStarTreeNode.getPageID());
        }
        return arrayList;
    }

    private N createRoot(N n, List<E> list) {
        for (SpatialEntry spatialEntry : list) {
            if (spatialEntry.isLeafEntry()) {
                ((AbstractNode)n).addLeafEntry((SpatialEntry)spatialEntry);
                continue;
            }
            ((AbstractNode)n).addDirectoryEntry((SpatialEntry)spatialEntry);
        }
        ((SpatialDirectoryEntry)this.getRootEntry()).setMBR(((AbstractRStarTreeNode)n).computeMBR());
        this.writeNode(n);
        if (this.getLogger().isDebuggingFiner()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("pageNo ").append(((AbstractExternalizablePage)n).getPageID());
            this.getLogger().debugFiner(stringBuilder.toString());
        }
        return n;
    }
}

