/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.AbstractDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.AbstractLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query.RStarTreeRangeQuery;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Arrays;

@Reference(authors="J. Kuan, P. Lewis", title="Fast k nearest neighbour search for R-tree family", booktitle="Proc. Int. Conf Information, Communications and Signal Processing, ICICS 1997", url="http://dx.doi.org/10.1109/ICICS.1997.652114")
public class EuclideanRStarTreeRangeQuery<O extends NumberVector>
extends RStarTreeRangeQuery<O> {
    private static final SquaredEuclideanDistanceFunction SQUARED = SquaredEuclideanDistanceFunction.STATIC;

    public EuclideanRStarTreeRangeQuery(AbstractRStarTree<?, ?, ?> abstractRStarTree, Relation<? extends O> relation) {
        super(abstractRStarTree, relation, EuclideanDistanceFunction.STATIC);
    }

    @Override
    public void getRangeForObject(O o, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        this.tree.statistics.countRangeQuery();
        double d2 = d * d;
        int[] nArray = new int[101];
        int n = 0;
        nArray[n++] = this.tree.getRootID();
        while (n > 0) {
            double d3;
            SpatialEntry spatialEntry;
            int n2;
            int n3 = nArray[--n];
            AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.tree.getNode(n3);
            int n4 = abstractRStarTreeNode.getNumEntries();
            if (abstractRStarTreeNode.isLeaf()) {
                for (n2 = 0; n2 < n4; ++n2) {
                    spatialEntry = (SpatialPointLeafEntry)abstractRStarTreeNode.getEntry(n2);
                    d3 = SQUARED.minDist((SpatialComparable)o, spatialEntry);
                    this.tree.statistics.countDistanceCalculation();
                    if (!(d3 <= d2)) continue;
                    modifiableDoubleDBIDList.add(Math.sqrt(d3), ((AbstractLeafEntry)((Object)spatialEntry)).getDBID());
                }
                continue;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                spatialEntry = (SpatialDirectoryEntry)abstractRStarTreeNode.getEntry(n2);
                d3 = SQUARED.minDist((SpatialComparable)o, spatialEntry);
                if (!(d3 <= d2)) continue;
                if (n == nArray.length) {
                    nArray = Arrays.copyOf(nArray, nArray.length + (nArray.length >>> 1));
                }
                nArray[n++] = ((AbstractDirectoryEntry)((Object)spatialEntry)).getEntryID();
            }
        }
    }
}

