/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.bulk;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.bulk.AbstractBulkSplit;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.SpatialSorter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

@Reference(title="On packing R-trees", authors="Kamel, I. and Faloutsos, C.", booktitle="Proc. of the second international conference on Information and knowledge management", url="http://dx.doi.org/10.1145/170088.170403")
public class SpatialSortBulkSplit
extends AbstractBulkSplit {
    final SpatialSorter sorter;

    protected SpatialSortBulkSplit(SpatialSorter spatialSorter) {
        this.sorter = spatialSorter;
    }

    @Override
    public <T extends SpatialComparable> List<List<T>> partition(List<T> list, int n, int n2) {
        this.sorter.sort(list);
        return super.trivialPartition(list, n, n2);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SORTER_ID = new OptionID("rtree.bulk.spatial-sort", "Strategy for spatial sorting in bulk loading.");
        SpatialSorter sorter;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(SORTER_ID, SpatialSorter.class);
            if (parameterization.grab(objectParameter)) {
                this.sorter = (SpatialSorter)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected SpatialSortBulkSplit makeInstance() {
            return new SpatialSortBulkSplit(this.sorter);
        }
    }
}

