/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import java.math.BigInteger;
import java.util.Random;

public final class MathUtil {
    public static final double TWOPI = Math.PI * 2;
    public static final double HALFPI = 1.5707963267948966;
    public static final double QUARTERPI = 0.7853981633974483;
    public static final double ONEHALFPI = 4.71238898038469;
    public static final double PISQUARE = Math.PI * Math.PI;
    public static final double SQRTPI = Math.sqrt(Math.PI);
    public static final double SQRTTWOPI = Math.sqrt(Math.PI * 2);
    public static final double SQRTHALFPI = Math.sqrt(1.5707963267948966);
    public static final double SQRT2 = Math.sqrt(2.0);
    public static final double SQRT5 = Math.sqrt(5.0);
    public static final double SQRTHALF = Math.sqrt(0.5);
    public static final double ONE_BY_SQRTPI = 1.0 / SQRTPI;
    public static final double ONE_BY_SQRTTWOPI = 1.0 / SQRTTWOPI;
    public static final double ONE_BY_LOG2 = 1.0 / Math.log(2.0);
    public static final double LOG2 = Math.log(2.0);
    public static final double LOG3 = Math.log(3.0);
    public static final double LOG10 = Math.log(10.0);
    public static final double LOGPI = Math.log(Math.PI);
    public static final double LOGPIHALF = LOGPI / 2.0;
    public static final double LOGTWOPI = Math.log(Math.PI * 2);
    public static final double LOGSQRTTWOPI = Math.log(SQRTTWOPI);
    public static final double LOGLOG2 = Math.log(LOG2);
    public static final double DEG2RAD = Math.PI / 180;
    public static final double RAD2DEG = 57.29577951308232;
    public static final int[] EMPTY_INTS = new int[0];

    private MathUtil() {
    }

    public static double log2(double d) {
        return Math.log(d) * ONE_BY_LOG2;
    }

    public static double fastHypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d2 / d;
            return d * Math.sqrt(1.0 + d3 * d3);
        }
        if (d2 != 0.0) {
            double d4 = d / d2;
            return d2 * Math.sqrt(1.0 + d4 * d4);
        }
        return 0.0;
    }

    public static double fastHypot3(double d, double d2, double d3) {
        double d4;
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d3 < 0.0) {
            d3 = -d3;
        }
        double d5 = d > d2 ? (d > d3 ? d : d3) : (d4 = d2 > d3 ? d2 : d3);
        if (d4 <= 0.0) {
            return 0.0;
        }
        return d4 * Math.sqrt((d /= d4) * d + (d2 /= d4) * d2 + (d3 /= d4) * d3);
    }

    public static double mahalanobisDistance(Matrix matrix, Vector vector) {
        double d = vector.transposeTimesTimes(matrix, vector);
        if (d < 0.0 && Math.abs(d) < 1.0E-9) {
            d = Math.abs(d);
        }
        return Math.sqrt(d);
    }

    public static double mahalanobisDistance(double[][] dArray, double[] dArray2) {
        double d = VMath.transposeTimesTimes(dArray2, dArray, dArray2);
        if (d < 0.0 && Math.abs(d) < 1.0E-9) {
            d = Math.abs(d);
        }
        return Math.sqrt(d);
    }

    public static double mahalanobisDistance(Matrix matrix, Vector vector, Vector vector2) {
        double d = VMath.mahalanobisDistance(matrix.getArrayRef(), vector.getArrayRef(), vector2.getArrayRef());
        if (d < 0.0 && Math.abs(d) < 1.0E-9) {
            d = Math.abs(d);
        }
        return Math.sqrt(d);
    }

    public static double mahalanobisDistance(double[][] dArray, double[] dArray2, double[] dArray3) {
        double d = VMath.mahalanobisDistance(dArray, dArray2, dArray3);
        if (d < 0.0 && Math.abs(d) < 1.0E-9) {
            d = Math.abs(d);
        }
        return Math.sqrt(d);
    }

    public static double pearsonCorrelationCoefficient(NumberVector numberVector, NumberVector numberVector2) {
        int n;
        int n2 = numberVector.getDimensionality();
        if (n2 != (n = numberVector2.getDimensionality())) {
            throw new IllegalArgumentException("Invalid arguments: number vectors differ in dimensionality.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = numberVector.doubleValue(0);
        double d5 = numberVector2.doubleValue(0);
        int n3 = 1;
        while (n3 < n2) {
            double d6 = numberVector.doubleValue(n3);
            double d7 = numberVector2.doubleValue(n3);
            double d8 = d6 - d4;
            double d9 = d7 - d5;
            double d10 = d6 - (d4 += d8 / (double)(++n3));
            double d11 = d7 - (d5 += d9 / (double)n3);
            d += d8 * d10;
            d2 += d9 * d11;
            d3 += d8 * d11;
        }
        if (!(d > 0.0) || !(d2 > 0.0)) {
            return d == d2 ? 1.0 : 0.0;
        }
        return d3 / Math.sqrt(d * d2);
    }

    public static double weightedPearsonCorrelationCoefficient(NumberVector numberVector, NumberVector numberVector2, double[] dArray) {
        int n;
        int n2 = numberVector.getDimensionality();
        if (n2 != (n = numberVector2.getDimensionality())) {
            throw new IllegalArgumentException("Invalid arguments: number vectors differ in dimensionality.");
        }
        if (n2 != dArray.length) {
            throw new IllegalArgumentException("Dimensionality doesn't agree to weights.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = dArray[0];
        double d5 = numberVector.doubleValue(0);
        double d6 = numberVector2.doubleValue(0);
        for (int i = 1; i < n2; ++i) {
            double d7 = numberVector.doubleValue(i);
            double d8 = numberVector2.doubleValue(i);
            double d9 = dArray[i];
            double d10 = d7 - d5;
            double d11 = d8 - d6;
            double d12 = d7 - (d5 += d10 * d9 / (d4 += d9));
            double d13 = d8 - (d6 += d11 * d9 / d4);
            d += d9 * d10 * d12;
            d2 += d9 * d11 * d13;
            d3 += d9 * d10 * d13;
        }
        if (!(d > 0.0) || !(d2 > 0.0)) {
            return d == d2 ? 1.0 : 0.0;
        }
        return d3 / Math.sqrt(d * d2);
    }

    public static double weightedPearsonCorrelationCoefficient(NumberVector numberVector, NumberVector numberVector2, NumberVector numberVector3) {
        int n;
        int n2 = numberVector.getDimensionality();
        if (n2 != (n = numberVector2.getDimensionality())) {
            throw new IllegalArgumentException("Invalid arguments: feature vectors differ in dimensionality.");
        }
        if (n2 != numberVector3.getDimensionality()) {
            throw new IllegalArgumentException("Dimensionality doesn't agree to weights.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = numberVector3.doubleValue(0);
        double d5 = numberVector.doubleValue(0);
        double d6 = numberVector2.doubleValue(0);
        for (int i = 1; i < n2; ++i) {
            double d7 = numberVector.doubleValue(i);
            double d8 = numberVector2.doubleValue(i);
            double d9 = numberVector3.doubleValue(i);
            double d10 = d7 - d5;
            double d11 = d8 - d6;
            double d12 = d7 - (d5 += d10 * d9 / (d4 += d9));
            double d13 = d8 - (d6 += d11 * d9 / d4);
            d += d9 * d10 * d12;
            d2 += d9 * d11 * d13;
            d3 += d9 * d10 * d13;
        }
        if (!(d > 0.0) || !(d2 > 0.0)) {
            return d == d2 ? 1.0 : 0.0;
        }
        return d3 / Math.sqrt(d * d2);
    }

    public static double pearsonCorrelationCoefficient(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = dArray2.length;
        if (n != n2) {
            throw new IllegalArgumentException("Invalid arguments: arrays differ in length.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = dArray[0];
        double d5 = dArray2[0];
        int n3 = 1;
        while (n3 < n) {
            double d6 = dArray[n3];
            double d7 = dArray2[n3];
            double d8 = d6 - d4;
            double d9 = d7 - d5;
            double d10 = d6 - (d4 += d8 / (double)(++n3));
            double d11 = d7 - (d5 += d9 / (double)n3);
            d += d8 * d10;
            d2 += d9 * d11;
            d3 += d8 * d11;
        }
        if (!(d > 0.0) || !(d2 > 0.0)) {
            return d == d2 ? 1.0 : 0.0;
        }
        return d3 / Math.sqrt(d * d2);
    }

    public static double weightedPearsonCorrelationCoefficient(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray.length;
        int n2 = dArray2.length;
        if (n != n2) {
            throw new IllegalArgumentException("Invalid arguments: arrays differ in length.");
        }
        if (n != dArray3.length) {
            throw new IllegalArgumentException("Dimensionality doesn't agree to weights.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = dArray3[0];
        double d5 = dArray[0];
        double d6 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            double d7 = dArray[i];
            double d8 = dArray2[i];
            double d9 = dArray3[i];
            double d10 = d7 - d5;
            double d11 = d8 - d6;
            double d12 = d7 - (d5 += d10 * d9 / (d4 += d9));
            double d13 = d8 - (d6 += d11 * d9 / d4);
            d += d9 * d10 * d12;
            d2 += d9 * d11 * d13;
            d3 += d9 * d10 * d13;
        }
        if (!(d > 0.0) || !(d2 > 0.0)) {
            return d == d2 ? 1.0 : 0.0;
        }
        return d3 / Math.sqrt(d * d2);
    }

    public static BigInteger factorial(BigInteger bigInteger) {
        BigInteger bigInteger2 = BigInteger.ONE;
        while (bigInteger.compareTo(BigInteger.ONE) > 0) {
            bigInteger2 = bigInteger2.multiply(bigInteger);
            bigInteger = bigInteger.subtract(BigInteger.ONE);
        }
        return bigInteger2;
    }

    public static long factorial(int n) {
        long l = 1L;
        for (long i = (long)n; i > 0L; --i) {
            l *= i;
        }
        return l;
    }

    public static long binomialCoefficient(long l, long l2) {
        long l3 = Math.max(l2, l - l2);
        double d = 1.0;
        long l4 = l;
        long l5 = 1L;
        while (l4 > l3) {
            d = d * (double)l4 / (double)l5;
            --l4;
            ++l5;
        }
        return (long)d;
    }

    public static double approximateFactorial(int n) {
        double d = 1.0;
        for (int i = n; i > 0; --i) {
            d *= (double)i;
        }
        return d;
    }

    public static double approximateBinomialCoefficient(int n, int n2) {
        int n3 = MathUtil.max(n2, n - n2);
        long l = 1L;
        int n4 = n;
        int n5 = 1;
        while (n4 > n3) {
            l = l * (long)n4 / (long)n5;
            --n4;
            ++n5;
        }
        return l;
    }

    public static long sumFirstIntegers(long l) {
        return (l - 1L) * l >> 1;
    }

    public static double[] randomDoubleArray(int n) {
        return MathUtil.randomDoubleArray(n, new Random());
    }

    public static double[] randomDoubleArray(int n, Random random) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = random.nextDouble();
        }
        return dArray;
    }

    public static double deg2rad(double d) {
        return d * (Math.PI / 180);
    }

    public static double rad2deg(double d) {
        return d * 57.29577951308232;
    }

    public static double angle(Vector vector, Vector vector2) {
        return MathUtil.angle(vector.getArrayRef(), vector2.getArrayRef());
    }

    public static double angle(double[] dArray, double[] dArray2) {
        double d;
        int n;
        int n2 = dArray.length >= dArray2.length ? dArray.length : dArray2.length;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < n2; ++n) {
            d = dArray[n];
            double d5 = dArray2[n];
            d2 += d * d5;
            d3 += d * d;
            d4 += d5 * d5;
        }
        for (n = n2; n < dArray.length; ++n) {
            d = dArray[n];
            d3 += d * d;
        }
        for (n = n2; n < dArray2.length; ++n) {
            d = dArray2[n];
            d4 += d * d;
        }
        return Math.sqrt(d2 / d3 * (d2 / d4));
    }

    public static double angle(Vector vector, Vector vector2, Vector vector3) {
        return MathUtil.angle(vector.getArrayRef(), vector2.getArrayRef(), vector3.getArrayRef());
    }

    public static double angle(double[] dArray, double[] dArray2, double[] dArray3) {
        double d;
        double d2;
        int n;
        int n2 = dArray.length >= dArray2.length ? dArray.length : dArray2.length;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (n = 0; n < n2; ++n) {
            d2 = n < dArray3.length ? dArray3[n] : 0.0;
            d = dArray[n] - d2;
            double d6 = dArray2[n] - d2;
            d3 += d * d6;
            d4 += d * d;
            d5 += d6 * d6;
        }
        for (n = n2; n < dArray.length; ++n) {
            d2 = n < dArray3.length ? dArray3[n] : 0.0;
            d = dArray[n] - d2;
            d4 += d * d;
        }
        for (n = n2; n < dArray2.length; ++n) {
            d2 = n < dArray3.length ? dArray3[n] : 0.0;
            d = dArray2[n] - d2;
            d5 += d * d;
        }
        return Math.sqrt(d3 / d4 * (d3 / d5));
    }

    public static double normAngle(double d) {
        return (d %= Math.PI * 2) > 0.0 ? d : d + Math.PI * 2;
    }

    public static double sinToCos(double d, double d2) {
        if (-1.0E-5 < d2 && d2 < 1.0E-5 || d2 > 0.99999 || d2 < -0.99999) {
            return Math.cos(d);
        }
        d = MathUtil.normAngle(d);
        double d3 = Math.sqrt(1.0 - d2 * d2);
        return d < 1.5707963267948966 || d > 4.71238898038469 ? d3 : -d3;
    }

    public static double cosToSin(double d, double d2) {
        if (-1.0E-5 < d2 && d2 < 1.0E-5 || d2 > 0.99999 || d2 < -0.99999) {
            return Math.sin(d);
        }
        d = MathUtil.normAngle(d);
        double d3 = Math.sqrt(1.0 - d2 * d2);
        return d < Math.PI ? d3 : -d3;
    }

    public static int nextPow2Int(int n) {
        --n;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return ++n;
    }

    public static long nextPow2Long(long l) {
        --l;
        l |= l >>> 1;
        l |= l >>> 2;
        l |= l >>> 4;
        l |= l >>> 16;
        l |= l >>> 32;
        return ++l;
    }

    public static int nextAllOnesInt(int n) {
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return n;
    }

    public static long nextAllOnesLong(long l) {
        l |= l >>> 1;
        l |= l >>> 2;
        l |= l >>> 4;
        l |= l >>> 16;
        l |= l >>> 32;
        return l;
    }

    public static double floatToDoubleUpper(float f) {
        if (Float.isNaN(f)) {
            return Double.NaN;
        }
        if (Float.isInfinite(f)) {
            if (f > 0.0f) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.longBitsToDouble(-4039728865751334913L);
        }
        long l = Double.doubleToRawLongBits(f);
        if ((l & Long.MIN_VALUE) == 0L) {
            if (l == 0L) {
                return Double.longBitsToDouble(3931642474694443008L);
            }
            if (f == Float.MIN_VALUE) {
                return Double.longBitsToDouble(3938397874135498751L);
            }
            if (Float.MIN_NORMAL > f && (double)f >= Double.MIN_NORMAL) {
                long l2 = Double.doubleToRawLongBits(Math.nextUp(f));
                l = (l >>> 1) + (l2 >>> 1) - 1L;
            } else {
                l += 0xFFFFFFFL;
            }
            return Double.longBitsToDouble(l);
        }
        if (l == Long.MIN_VALUE) {
            return -0.0;
        }
        if (f == -1.4E-45f) {
            return Double.longBitsToDouble(-5291729562160332799L);
        }
        if (-1.1754944E-38f < f && (double)f <= -2.2250738585072014E-308) {
            long l3 = Double.doubleToRawLongBits(Math.nextUp(f));
            l = (l >>> 1) + (l3 >>> 1) + 1L;
        } else {
            l -= 0xFFFFFFFL;
        }
        return Double.longBitsToDouble(l);
    }

    public static double floatToDoubleLower(float f) {
        if (Float.isNaN(f)) {
            return Double.NaN;
        }
        if (Float.isInfinite(f)) {
            if (f < 0.0f) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.longBitsToDouble(5183643171103440895L);
        }
        long l = Double.doubleToRawLongBits(f);
        if ((l & Long.MIN_VALUE) == 0L) {
            if (l == 0L) {
                return 0.0;
            }
            if (f == Float.MIN_VALUE) {
                return Double.longBitsToDouble(3931642474694443009L);
            }
            if (Float.MIN_NORMAL > f) {
                long l2 = Double.doubleToRawLongBits(-Math.nextUp(-f));
                l = (l >>> 1) + (l2 >>> 1) + 1L;
            } else {
                l -= 0xFFFFFFFL;
            }
            return Double.longBitsToDouble(l);
        }
        if (l == Long.MIN_VALUE) {
            return Double.longBitsToDouble(-5291729562160332800L);
        }
        if (f == -1.4E-45f) {
            return Double.longBitsToDouble(-5284974162719277057L);
        }
        if (-1.1754944E-38f < f) {
            long l3 = Double.doubleToRawLongBits(-Math.nextUp(-f));
            l = (l >>> 1) + (l3 >>> 1) - 1L;
        } else {
            l += 0xFFFFFFFL;
        }
        return Double.longBitsToDouble(l);
    }

    public static double log1mexp(double d) {
        return d > -LOG2 ? Math.log(-Math.expm1(d)) : Math.log1p(-Math.exp(d));
    }

    public static double powi(double d, int n) {
        if (n <= 2) {
            return Math.pow(d, n);
        }
        double d2 = d;
        double d3 = (n & 1) == 1 ? d : 1.0;
        while (true) {
            d2 *= d2;
            if ((n >>= 1) == 1) {
                return d3 * d2;
            }
            if ((n & 1) == 0) continue;
            d3 *= d2;
        }
    }

    public static int ipowi(int n, int n2) {
        if (n2 <= 2) {
            return (int)Math.pow(n, n2);
        }
        int n3 = n;
        int n4 = (n2 & 1) == 1 ? n : 1;
        while (true) {
            n3 *= n3;
            if ((n2 >>= 1) == 1) {
                return n4 * n3;
            }
            if ((n2 & 1) == 0) continue;
            n4 *= n3;
        }
    }

    public static int[] sequence(int n, int n2) {
        if (n >= n2) {
            return EMPTY_INTS;
        }
        int[] nArray = new int[n2 - n];
        int n3 = 0;
        while (n < n2) {
            nArray[n3] = n++;
            ++n3;
        }
        return nArray;
    }

    public static double max(double d, double d2) {
        return d >= d2 ? d : d2;
    }

    public static double max(double d, double d2, double d3) {
        return d >= d2 ? (d >= d3 ? d : d3) : (d2 >= d3 ? d2 : d3);
    }

    public static double max(double d, double d2, double d3, double d4) {
        return d >= d2 ? (d >= d3 ? (d >= d4 ? d : d4) : (d3 >= d4 ? d3 : d4)) : (d2 >= d3 ? (d2 >= d4 ? d2 : d4) : (d3 >= d4 ? d3 : d4));
    }

    public static int max(int n, int n2) {
        return n >= n2 ? n : n2;
    }

    public static int max(int n, int n2, int n3) {
        return n >= n2 ? (n >= n3 ? n : n3) : (n2 >= n3 ? n2 : n3);
    }

    public static int max(int n, int n2, int n3, int n4) {
        return n >= n2 ? (n >= n3 ? (n >= n4 ? n : n4) : (n3 >= n4 ? n3 : n4)) : (n2 >= n3 ? (n2 >= n4 ? n2 : n4) : (n3 >= n4 ? n3 : n4));
    }

    public static double min(double d, double d2) {
        return d <= d2 ? d : d2;
    }

    public static double min(double d, double d2, double d3) {
        return d <= d2 ? (d <= d3 ? d : d3) : (d2 <= d3 ? d2 : d3);
    }

    public static double min(double d, double d2, double d3, double d4) {
        return d <= d2 ? (d <= d3 ? (d <= d4 ? d : d4) : (d3 <= d4 ? d3 : d4)) : (d2 <= d3 ? (d2 <= d4 ? d2 : d4) : (d3 <= d4 ? d3 : d4));
    }

    public static int min(int n, int n2) {
        return n <= n2 ? n : n2;
    }

    public static int min(int n, int n2, int n3) {
        return n <= n2 ? (n <= n3 ? n : n3) : (n2 <= n3 ? n2 : n3);
    }

    public static int min(int n, int n2, int n3, int n4) {
        return n <= n2 ? (n <= n3 ? (n <= n4 ? n : n4) : (n3 <= n4 ? n3 : n4)) : (n2 <= n3 ? (n2 <= n4 ? n2 : n4) : (n3 <= n4 ? n3 : n4));
    }
}

