/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.dimensionsimilarity;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.dimensionsimilarity.DimensionSimilarity;
import de.lmu.ifi.dbs.elki.math.dimensionsimilarity.DimensionSimilarityMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class CovarianceDimensionSimilarity
implements DimensionSimilarity<NumberVector> {
    public static final CovarianceDimensionSimilarity STATIC = new CovarianceDimensionSimilarity();

    protected CovarianceDimensionSimilarity() {
    }

    @Override
    public void computeDimensionSimilarites(Relation<? extends NumberVector> relation, DBIDs dBIDs, DimensionSimilarityMatrix dimensionSimilarityMatrix) {
        int n;
        int n2 = dimensionSimilarityMatrix.size();
        CovarianceMatrix covarianceMatrix = CovarianceMatrix.make(relation, dBIDs);
        double[][] dArray = covarianceMatrix.destroyToSampleMatrix().getArrayRef();
        for (n = 0; n < dArray.length; ++n) {
            dArray[n][n] = 1.0 / Math.sqrt(dArray[n][n]);
        }
        for (n = 0; n < n2; ++n) {
            int n3 = dimensionSimilarityMatrix.dim(n);
            for (int i = n + 1; i < n2; ++i) {
                int n4 = dimensionSimilarityMatrix.dim(i);
                dimensionSimilarityMatrix.set(n, i, dArray[n3][n4] * dArray[n3][n3] * dArray[n4][n4]);
            }
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected CovarianceDimensionSimilarity makeInstance() {
            return STATIC;
        }
    }
}

