/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.dimensionsimilarity;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.dimensionsimilarity.DimensionSimilarityMatrix;
import de.lmu.ifi.dbs.elki.math.dimensionsimilarity.SlopeDimensionSimilarity;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Interactive Data Mining with 3D-Parallel-Coordinate-Trees", booktitle="Proc. of the 2013 ACM International Conference on Management of Data (SIGMOD)", url="http://dx.doi.org/10.1145/2463676.2463696")
public class SlopeInversionDimensionSimilarity
extends SlopeDimensionSimilarity {
    public static final SlopeInversionDimensionSimilarity STATIC = new SlopeInversionDimensionSimilarity();

    protected SlopeInversionDimensionSimilarity() {
    }

    @Override
    public void computeDimensionSimilarites(Relation<? extends NumberVector> relation, DBIDs dBIDs, DimensionSimilarityMatrix dimensionSimilarityMatrix) {
        Object object;
        int n = dimensionSimilarityMatrix.size();
        int n2 = dBIDs.size();
        int[][][] nArray = new int[n][n][40];
        int[][][] nArray2 = new int[n][n][40];
        Object object2 = RelationUtil.computeMinMax(relation);
        double[] dArray = object2[0];
        double[] dArray2 = object2[1];
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            dArray2[n3] = dArray2[n3] - dArray[i];
            dArray2[i] = dArray2[i] > 0.0 ? 1.0 / dArray2[i] : 1.0;
        }
        object2 = new double[n];
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            int n4;
            NumberVector numberVector = relation.get(dBIDIter);
            for (n4 = 0; n4 < n; ++n4) {
                object2[n4] = (double[])((numberVector.doubleValue(dimensionSimilarityMatrix.dim(n4)) - dArray[n4]) * dArray2[n4]);
            }
            for (n4 = 0; n4 < n - 1; ++n4) {
                for (int i = n4 + 1; i < n; ++i) {
                    object = object2[i] - object2[n4] + 1.0;
                    int n5 = (int)Math.round(object * 20.0);
                    n5 = n5 < 0 ? 0 : (n5 >= 40 ? 39 : n5);
                    int[] nArray3 = nArray[n4][i];
                    int n6 = n5;
                    nArray3[n6] = nArray3[n6] + 1;
                    object = object2[i] + object2[n4];
                    n5 = (int)Math.round(object * 20.0);
                    n5 = n5 < 0 ? 0 : (n5 >= 40 ? 39 : n5);
                    int[] nArray4 = nArray2[n4][i];
                    int n7 = n5;
                    nArray4[n7] = nArray4[n7] + 1;
                }
            }
            dBIDIter.advance();
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double d;
                int n8;
                double d2 = 0.0;
                object = 0.0;
                int[] nArray5 = nArray[i][j];
                for (n8 = 0; n8 < 40; ++n8) {
                    if (nArray5[n8] <= 0) continue;
                    d = (double)nArray5[n8] / (double)n2;
                    d2 += d * Math.log(d);
                }
                nArray5 = nArray2[i][j];
                for (n8 = 0; n8 < 40; ++n8) {
                    if (nArray5[n8] <= 0) continue;
                    d = (double)nArray5[n8] / (double)n2;
                    object += d * Math.log(d);
                }
                if (d2 >= object) {
                    d2 = 1.0 + d2 / LOG_PRECISION;
                    dimensionSimilarityMatrix.set(i, j, d2);
                    continue;
                }
                object = 1.0 + object / LOG_PRECISION;
                dimensionSimilarityMatrix.set(i, j, -object);
            }
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SlopeInversionDimensionSimilarity makeInstance() {
            return STATIC;
        }
    }
}

