/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.pairs.IntIntPair;
import gnu.trove.list.array.TIntArrayList;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class LinearEquationSystem {
    private static final Logging LOG = Logging.getLogger(LinearEquationSystem.class);
    private static final int TRIVAL_PIVOT_SEARCH = 0;
    private static final int TOTAL_PIVOT_SEARCH = 1;
    private boolean solvable;
    private boolean solved;
    private int rank;
    private double[][] coeff;
    private double[] rhs;
    private int[] row;
    private int[] col;
    private double[] x_0;
    private double[][] u;
    private boolean reducedRowEchelonForm;

    public LinearEquationSystem(double[][] dArray, double[] dArray2) {
        int n;
        if (dArray == null) {
            throw new IllegalArgumentException("Coefficient array is null!");
        }
        if (dArray2 == null) {
            throw new IllegalArgumentException("Right hand side is null!");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Coefficient matrix and right hand side differ in row dimensionality!");
        }
        this.coeff = dArray;
        this.rhs = dArray2;
        this.row = new int[this.coeff.length];
        for (n = 0; n < this.coeff.length; ++n) {
            this.row[n] = n;
        }
        this.col = new int[this.coeff[0].length];
        for (n = 0; n < this.coeff[0].length; ++n) {
            this.col[n] = n;
        }
        this.rank = 0;
        this.x_0 = null;
        this.solved = false;
        this.solvable = false;
        this.reducedRowEchelonForm = false;
    }

    public LinearEquationSystem(double[][] dArray, double[] dArray2, int[] nArray, int[] nArray2) {
        if (dArray == null) {
            throw new IllegalArgumentException("Coefficient array is null!");
        }
        if (dArray2 == null) {
            throw new IllegalArgumentException("Right hand side is null!");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Coefficient matrix and right hand side differ in row dimensionality!");
        }
        if (nArray.length != dArray.length) {
            throw new IllegalArgumentException("Coefficient matrix and row permutation array differ in row dimensionality!");
        }
        if (nArray2.length != dArray[0].length) {
            throw new IllegalArgumentException("Coefficient matrix and column permutation array differ in column dimensionality!");
        }
        this.coeff = dArray;
        this.rhs = dArray2;
        this.row = nArray;
        this.col = nArray2;
        this.rank = 0;
        this.x_0 = null;
        this.solved = false;
        this.solvable = false;
        this.reducedRowEchelonForm = false;
    }

    public double[][] getCoefficents() {
        return (double[][])this.coeff.clone();
    }

    public double[] getRHS() {
        return (double[])this.rhs.clone();
    }

    public int[] getRowPermutations() {
        return (int[])this.row.clone();
    }

    public int[] getColumnPermutations() {
        return (int[])this.col.clone();
    }

    public boolean isSolved() {
        return this.solved;
    }

    public void solveByTotalPivotSearch() {
        this.solve(1);
    }

    public void solveByTrivialPivotSearch() {
        this.solve(0);
    }

    public boolean isSolvable() {
        return this.solvable && this.solved;
    }

    public String equationsToString(String string, int n) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMinimumFractionDigits(n);
        decimalFormat.setMaximumFractionDigits(n);
        decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        decimalFormat.setNegativePrefix("");
        decimalFormat.setPositivePrefix("");
        return this.equationsToString(string, decimalFormat);
    }

    public String equationsToString(String string, NumberFormat numberFormat) {
        if (this.coeff == null || this.rhs == null || this.row == null || this.col == null) {
            throw new NullPointerException();
        }
        int[] nArray = this.maxIntegerDigits(this.coeff);
        int n = this.maxIntegerDigits(this.rhs);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append('\n').append(string);
        for (int i = 0; i < this.coeff.length; ++i) {
            for (int j = 0; j < this.coeff[this.row[0]].length; ++j) {
                this.format(numberFormat, stringBuilder, this.coeff[this.row[i]][this.col[j]], nArray[this.col[j]]);
                stringBuilder.append(" * x_").append(this.col[j]);
            }
            stringBuilder.append(" =");
            this.format(numberFormat, stringBuilder, this.rhs[this.row[i]], n);
            if (i < this.coeff.length - 1) {
                stringBuilder.append('\n').append(string);
                continue;
            }
            stringBuilder.append('\n').append(string);
        }
        return stringBuilder.toString();
    }

    public String equationsToString(NumberFormat numberFormat) {
        return this.equationsToString("", numberFormat);
    }

    public String equationsToString(int n) {
        return this.equationsToString("", n);
    }

    public String solutionToString(int n) {
        if (!this.isSolvable()) {
            throw new IllegalStateException("System is not solvable!");
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMinimumFractionDigits(n);
        decimalFormat.setMaximumFractionDigits(n);
        decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        decimalFormat.setNegativePrefix("");
        decimalFormat.setPositivePrefix("");
        int n2 = this.coeff[0].length >> 1;
        int n3 = this.u.length;
        int n4 = this.integerDigits(n3);
        int n5 = this.maxIntegerDigits(this.x_0);
        int[] nArray = this.maxIntegerDigits(this.u);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.x_0.length; ++i) {
            double d = this.x_0[i];
            this.format(decimalFormat, stringBuilder, d, n5);
            for (int j = 0; j < this.u[0].length; ++j) {
                if (i == n2) {
                    stringBuilder.append("  +  a_").append(j).append(" * ");
                } else {
                    stringBuilder.append("          ");
                    for (int k = 0; k < n4; ++k) {
                        stringBuilder.append(' ');
                    }
                }
                this.format(decimalFormat, stringBuilder, this.u[i][j], nArray[j]);
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private void reducedRowEchelonForm(int n) {
        int n2 = this.coeff.length;
        int n3 = this.coeff[0].length;
        int n4 = -1;
        boolean bl = false;
        while (!bl) {
            IntIntPair intIntPair = new IntIntPair(0, 0);
            IntIntPair intIntPair2 = new IntIntPair(++n4, n4);
            switch (n) {
                case 0: {
                    intIntPair = this.nonZeroPivotSearch(n4);
                    break;
                }
                case 1: {
                    intIntPair = this.totalPivotSearch(n4);
                }
            }
            int n5 = intIntPair.first;
            int n6 = intIntPair.second;
            double d = this.coeff[this.row[n5]][this.col[n6]];
            if (LOG.isDebugging()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("equations ").append(this.equationsToString(4));
                stringBuilder.append("  *** pivot at (").append(n5).append(',').append(n6).append(") = ").append(d).append('\n');
                LOG.debugFine(stringBuilder.toString());
            }
            this.permutePivot(intIntPair, intIntPair2);
            if (Math.abs(d) <= 0.001) {
                bl = true;
            }
            if (Math.abs(d) > 0.001) {
                ++this.rank;
                this.pivotOperation(n4);
            }
            if (n4 != n2 - 1 && n4 != n3 - 1) continue;
            bl = true;
        }
        this.reducedRowEchelonForm = true;
    }

    private IntIntPair totalPivotSearch(int n) {
        double d = 0.0;
        int n2 = n;
        int n3 = n;
        for (int i = n; i < this.coeff.length; ++i) {
            for (int j = n; j < this.coeff[0].length; ++j) {
                double d2 = Math.abs(this.coeff[this.row[i]][this.col[j]]);
                if (!(d < d2)) continue;
                d = d2;
                n2 = i;
                n3 = j;
            }
        }
        return new IntIntPair(n2, n3);
    }

    private IntIntPair nonZeroPivotSearch(int n) {
        for (int i = n; i < this.coeff.length; ++i) {
            for (int j = n; j < this.coeff[0].length; ++j) {
                double d = Math.abs(this.coeff[this.row[i]][this.col[j]]);
                if (!(d > 0.0)) continue;
                return new IntIntPair(i, j);
            }
        }
        return new IntIntPair(n, n);
    }

    private void permutePivot(IntIntPair intIntPair, IntIntPair intIntPair2) {
        int n = intIntPair.first;
        int n2 = intIntPair.second;
        int n3 = intIntPair2.first;
        int n4 = intIntPair2.second;
        int n5 = this.row[n3];
        this.row[n3] = this.row[n];
        this.row[n] = n5;
        n5 = this.col[n4];
        this.col[n4] = this.col[n2];
        this.col[n2] = n5;
    }

    private void pivotOperation(int n) {
        int n2;
        double d = this.coeff[this.row[n]][this.col[n]];
        this.coeff[this.row[n]][this.col[n]] = 1.0;
        for (n2 = n + 1; n2 < this.coeff[n].length; ++n2) {
            double[] dArray = this.coeff[this.row[n]];
            int n3 = this.col[n2];
            dArray[n3] = dArray[n3] / d;
        }
        int n4 = this.row[n];
        this.rhs[n4] = this.rhs[n4] / d;
        if (LOG.isDebugging()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("set pivot element to 1 ").append(this.equationsToString(4));
            LOG.debugFine(stringBuilder.toString());
        }
        for (n2 = 0; n2 < this.coeff.length; ++n2) {
            if (n2 == n) continue;
            double d2 = this.coeff[this.row[n2]][this.col[n]];
            this.coeff[this.row[n2]][this.col[n]] = 0.0;
            for (int i = n + 1; i < this.coeff[0].length; ++i) {
                this.coeff[this.row[n2]][this.col[i]] = this.coeff[this.row[n2]][this.col[i]] - this.coeff[this.row[n]][this.col[i]] * d2;
            }
            this.rhs[this.row[n2]] = this.rhs[this.row[n2]] - this.rhs[this.row[n]] * d2;
        }
        if (LOG.isDebugging()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("after pivot operation ").append(this.equationsToString(4));
            LOG.debugFine(stringBuilder.toString());
        }
    }

    private void solve(int n) throws NullPointerException {
        int n2;
        if (this.solved) {
            return;
        }
        if (!this.reducedRowEchelonForm) {
            this.reducedRowEchelonForm(n);
        }
        if (!this.isSolvable(n)) {
            if (LOG.isDebugging()) {
                LOG.debugFine("Equation system is not solvable!");
            }
            return;
        }
        int n3 = this.coeff[0].length;
        TIntArrayList tIntArrayList = new TIntArrayList();
        this.x_0 = new double[n3];
        block0: for (int i = 0; i < this.coeff.length; ++i) {
            for (n2 = i; n2 < this.coeff[this.row[i]].length; ++n2) {
                if (this.coeff[this.row[i]][this.col[n2]] != 1.0) continue;
                this.x_0[this.col[i]] = this.rhs[this.row[i]];
                tIntArrayList.add(this.col[i]);
                continue block0;
            }
        }
        TIntArrayList tIntArrayList2 = new TIntArrayList();
        for (n2 = 0; n2 < this.coeff[0].length; ++n2) {
            if (tIntArrayList.contains(n2)) continue;
            tIntArrayList2.add(n2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (LOG.isDebugging()) {
            stringBuilder.append("\nSpecial solution x_0 = [").append(FormatUtil.format(this.x_0, ",", FormatUtil.NF4)).append(']');
            stringBuilder.append("\nbound Indices ").append(tIntArrayList);
            stringBuilder.append("\nfree Indices ").append(tIntArrayList2);
        }
        tIntArrayList.sort();
        int n4 = 0;
        int n5 = 0;
        this.u = new double[n3][tIntArrayList2.size()];
        for (int i = 0; i < this.u[0].length; ++i) {
            for (int j = 0; j < this.u.length; ++j) {
                if (n4 < tIntArrayList2.size() && j == tIntArrayList2.get(n4)) {
                    this.u[j][i] = 1.0;
                    continue;
                }
                if (n5 >= tIntArrayList.size() || j != tIntArrayList.get(n5)) continue;
                this.u[j][i] = -this.coeff[this.row[n5]][tIntArrayList2.get(n4)];
                ++n5;
            }
            ++n4;
            n5 = 0;
        }
        if (LOG.isDebugging()) {
            stringBuilder.append("\nU");
            for (double[] dArray : this.u) {
                stringBuilder.append('\n').append(FormatUtil.format(dArray, ",", FormatUtil.NF4));
            }
            LOG.debugFine(stringBuilder.toString());
        }
        this.solved = true;
    }

    private boolean isSolvable(int n) throws NullPointerException {
        if (this.solved) {
            return this.solvable;
        }
        if (!this.reducedRowEchelonForm) {
            this.reducedRowEchelonForm(n);
        }
        for (int i = this.rank; i < this.rhs.length; ++i) {
            if (!(Math.abs(this.rhs[this.row[i]]) > 0.001)) continue;
            this.solvable = false;
            return false;
        }
        this.solvable = true;
        return true;
    }

    private int[] maxIntegerDigits(double[][] dArray) {
        int[] nArray = new int[dArray[0].length];
        for (int i = 0; i < dArray[0].length; ++i) {
            for (double[] dArray2 : dArray) {
                nArray[i] = Math.max(nArray[i], this.integerDigits(dArray2[i]));
            }
        }
        return nArray;
    }

    private int maxIntegerDigits(double[] dArray) {
        int n = 0;
        for (double d : dArray) {
            n = Math.max(n, this.integerDigits(d));
        }
        return n;
    }

    private int integerDigits(double d) {
        double d2 = Math.abs(d);
        if (d2 < 10.0) {
            return 1;
        }
        return (int)Math.log10(d2) + 1;
    }

    private void format(NumberFormat numberFormat, StringBuilder stringBuilder, double d, int n) {
        if (d >= 0.0) {
            stringBuilder.append(" + ");
        } else {
            stringBuilder.append(" - ");
        }
        int n2 = n - this.integerDigits(d);
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(numberFormat.format(Math.abs(d)));
    }

    public int subspacedim() {
        return this.coeff[0].length - this.coeff.length;
    }
}

