/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import java.io.Serializable;

public class QRDecomposition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double[][] QR;
    private int m;
    private int n;
    private double[] Rdiag;

    public QRDecomposition(Matrix matrix) {
        this(matrix.getArrayRef(), matrix.getRowDimensionality(), matrix.getColumnDimensionality());
    }

    public QRDecomposition(double[][] dArray, int n, int n2) {
        this.QR = new Matrix(dArray).getArrayCopy();
        this.m = this.QR.length;
        this.n = this.QR[0].length;
        this.Rdiag = new double[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            double d = 0.0;
            for (n3 = i; n3 < n; ++n3) {
                d = MathUtil.fastHypot(d, this.QR[n3][i]);
            }
            if (d != 0.0) {
                if (this.QR[i][i] < 0.0) {
                    d = -d;
                }
                for (n3 = i; n3 < n; ++n3) {
                    double[] dArray2 = this.QR[n3];
                    int n4 = i;
                    dArray2[n4] = dArray2[n4] / d;
                }
                double[] dArray3 = this.QR[i];
                int n5 = i;
                dArray3[n5] = dArray3[n5] + 1.0;
                for (n3 = i + 1; n3 < n2; ++n3) {
                    int n6;
                    double d2 = 0.0;
                    for (n6 = i; n6 < n; ++n6) {
                        d2 += this.QR[n6][i] * this.QR[n6][n3];
                    }
                    d2 = -d2 / this.QR[i][i];
                    for (n6 = i; n6 < n; ++n6) {
                        double[] dArray4 = this.QR[n6];
                        int n7 = n3;
                        dArray4[n7] = dArray4[n7] + d2 * this.QR[n6][i];
                    }
                }
            }
            this.Rdiag[i] = -d;
        }
    }

    public boolean isFullRank() {
        for (int i = 0; i < this.n; ++i) {
            if (this.Rdiag[i] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix getH() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArrayRef();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = i >= j ? this.QR[i][j] : 0.0;
            }
        }
        return matrix;
    }

    public Matrix getR() {
        Matrix matrix = new Matrix(this.n, this.n);
        double[][] dArray = matrix.getArrayRef();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = i < j ? this.QR[i][j] : (i == j ? this.Rdiag[i] : 0.0);
            }
        }
        return matrix;
    }

    public Matrix getQ() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArrayRef();
        for (int i = this.n - 1; i >= 0; --i) {
            int n;
            for (n = 0; n < this.m; ++n) {
                dArray[n][i] = 0.0;
            }
            dArray[i][i] = 1.0;
            for (n = i; n < this.n; ++n) {
                int n2;
                if (this.QR[i][i] == 0.0) continue;
                double d = 0.0;
                for (n2 = i; n2 < this.m; ++n2) {
                    d += this.QR[n2][i] * dArray[n2][n];
                }
                d = -d / this.QR[i][i];
                for (n2 = i; n2 < this.m; ++n2) {
                    double[] dArray2 = dArray[n2];
                    int n3 = n;
                    dArray2[n3] = dArray2[n3] + d * this.QR[n2][i];
                }
            }
        }
        return matrix;
    }

    public Matrix solve(Matrix matrix) {
        if (matrix.getRowDimensionality() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int n = matrix.getColumnDimensionality();
        Matrix matrix2 = matrix.copy();
        this.solveInplace(matrix2.getArrayRef(), n);
        return matrix2.getMatrix(0, this.n - 1, 0, n - 1);
    }

    public double[][] solve(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (n != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        Matrix matrix = new Matrix(dArray).copy();
        this.solveInplace(matrix.getArrayRef(), n2);
        return matrix.getMatrix(0, this.n - 1, 0, n2 - 1).getArrayRef();
    }

    private void solveInplace(double[][] dArray, int n) {
        int n2;
        int n3;
        for (n3 = 0; n3 < this.n; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                int n4;
                double d = 0.0;
                for (n4 = n3; n4 < this.m; ++n4) {
                    d += this.QR[n4][n3] * dArray[n4][n2];
                }
                d = -d / this.QR[n3][n3];
                for (n4 = n3; n4 < this.m; ++n4) {
                    double[] dArray2 = dArray[n4];
                    int n5 = n2;
                    dArray2[n5] = dArray2[n5] + d * this.QR[n4][n3];
                }
            }
        }
        for (n3 = this.n - 1; n3 >= 0; --n3) {
            n2 = 0;
            while (n2 < n) {
                double[] dArray3 = dArray[n3];
                int n6 = n2++;
                dArray3[n6] = dArray3[n6] / this.Rdiag[n3];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                for (int i = 0; i < n; ++i) {
                    double[] dArray4 = dArray[n2];
                    int n7 = i;
                    dArray4[n7] = dArray4[n7] - dArray[n3][i] * this.QR[n2][n3];
                }
            }
        }
    }
}

