/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenvalueDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.CovarianceMatrixBuilder;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.StandardCovarianceMatrixBuilder;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class PCARunner {
    protected CovarianceMatrixBuilder covarianceMatrixBuilder;

    public PCARunner(CovarianceMatrixBuilder covarianceMatrixBuilder) {
        this.covarianceMatrixBuilder = covarianceMatrixBuilder;
    }

    public PCAResult processDatabase(Relation<? extends NumberVector> relation) {
        return this.processCovarMatrix(this.covarianceMatrixBuilder.processDatabase(relation));
    }

    public PCAResult processIds(DBIDs dBIDs, Relation<? extends NumberVector> relation) {
        return this.processCovarMatrix(this.covarianceMatrixBuilder.processIds(dBIDs, relation));
    }

    public PCAResult processQueryResult(DoubleDBIDList doubleDBIDList, Relation<? extends NumberVector> relation) {
        return this.processCovarMatrix(this.covarianceMatrixBuilder.processQueryResults(doubleDBIDList, relation));
    }

    public PCAResult processCovarMatrix(Matrix matrix) {
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix);
        return this.processEVD(eigenvalueDecomposition);
    }

    public PCAResult processEVD(EigenvalueDecomposition eigenvalueDecomposition) {
        SortedEigenPairs sortedEigenPairs = new SortedEigenPairs(eigenvalueDecomposition, false);
        return new PCAResult(sortedEigenPairs);
    }

    public CovarianceMatrixBuilder getCovarianceMatrixBuilder() {
        return this.covarianceMatrixBuilder;
    }

    public void setCovarianceMatrixBuilder(CovarianceMatrixBuilder covarianceMatrixBuilder) {
        this.covarianceMatrixBuilder = covarianceMatrixBuilder;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID PCA_COVARIANCE_MATRIX = new OptionID("pca.covariance", "Class used to compute the covariance matrix.");
        protected CovarianceMatrixBuilder covarianceMatrixBuilder;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(PCA_COVARIANCE_MATRIX, (Class<?>)CovarianceMatrixBuilder.class, StandardCovarianceMatrixBuilder.class);
            if (parameterization.grab(objectParameter)) {
                this.covarianceMatrixBuilder = (CovarianceMatrixBuilder)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected PCARunner makeInstance() {
            return new PCARunner(this.covarianceMatrixBuilder);
        }
    }
}

