/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="W. Hoeffding", title="A non-parametric test of independence", booktitle="The Annals of Mathematical Statistics 19", url="http://www.jstor.org/stable/2236021")
public class HoeffdingsDDependenceMeasure
extends AbstractDependenceMeasure {
    public static final HoeffdingsDDependenceMeasure STATIC = new HoeffdingsDDependenceMeasure();
    private static final double[] TABVAL = new double[]{0.5297, 0.4918, 0.4565, 0.4236, 0.393, 0.3648, 0.3387, 0.3146, 0.2924, 0.2719, 0.253, 0.2355, 0.2194, 0.2045, 0.1908, 0.1781, 0.1663, 0.1554, 0.1453, 0.1359, 0.1273, 0.1192, 0.1117, 0.1047, 0.0982, 0.0921, 0.0864, 0.0812, 0.0762, 0.0716, 0.0673, 0.0633, 0.0595, 0.056, 0.0527, 0.0496, 0.0467, 0.044, 0.0414, 0.039, 0.0368, 0.0347, 0.0327, 0.0308, 0.0291, 0.0274, 0.0259, 0.0244, 0.023, 0.0217, 0.0205, 0.0194, 0.0183, 0.0173, 0.0163, 0.0154, 0.0145, 0.0137, 0.013, 0.0123, 0.0116, 0.011, 0.0104, 0.0098, 0.0093, 0.0087, 0.0083, 0.0078, 0.0074, 0.007, 0.0066, 0.0063, 0.0059, 0.0056, 0.0053, 0.005, 0.0047, 0.0045, 0.0042, 0.0025, 0.0014, 8.0E-4, 5.0E-4, 3.0E-4, 2.0E-4, 1.0E-4};
    private static final double[] TABPOS = new double[]{1.1, 1.15, 1.2, 1.25, 1.3, 1.35, 1.4, 1.45, 1.5, 1.55, 1.6, 1.65, 1.7, 1.75, 1.8, 1.85, 1.9, 1.95, 2.0, 2.05, 2.1, 2.15, 2.2, 2.25, 2.3, 2.35, 2.4, 2.45, 2.5, 2.55, 2.6, 2.65, 2.7, 2.75, 2.8, 2.85, 2.9, 2.95, 3.0, 3.05, 3.1, 3.15, 3.2, 3.25, 3.3, 3.35, 3.4, 3.45, 3.5, 3.55, 3.6, 3.65, 3.7, 3.75, 3.8, 3.85, 3.9, 3.95, 4.0, 4.05, 4.1, 4.15, 4.2, 4.25, 4.3, 4.35, 4.4, 4.45, 4.5, 4.55, 4.6, 4.65, 4.7, 4.75, 4.8, 4.85, 4.9, 4.95, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5};

    protected HoeffdingsDDependenceMeasure() {
    }

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> numberArrayAdapter, A a, NumberArrayAdapter<?, B> numberArrayAdapter2, B b) {
        int n = HoeffdingsDDependenceMeasure.size(numberArrayAdapter, a, numberArrayAdapter2, b);
        assert (n > 4) : "Hoeffdings D needs at least 5 elements!";
        if (n <= 4) {
            return Double.NaN;
        }
        double[] dArray = HoeffdingsDDependenceMeasure.ranks(numberArrayAdapter, a, n);
        double[] dArray2 = HoeffdingsDDependenceMeasure.ranks(numberArrayAdapter2, b, n);
        double[] dArray3 = HoeffdingsDDependenceMeasure.computeBivariateRanks(numberArrayAdapter, a, numberArrayAdapter2, b, n);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray3[i] * (dArray3[i] - 1.0);
            d2 += (dArray[i] - 1.0) * (dArray[i] - 2.0) * (dArray2[i] - 1.0) * (dArray2[i] - 2.0);
            d3 += (dArray[i] - 2.0) * (dArray2[i] - 2.0) * dArray3[i];
        }
        double d4 = ((double)n - 3.0) * d + d2 / (double)(n - 2) - 2.0 * d3;
        double d5 = (double)n * ((double)n - 1.0) * ((double)n - 3.0) * ((double)n - 4.0);
        double d6 = 30.0 * d4 / d5;
        return d6 < 1.0 ? d6 : 1.0;
    }

    protected static <A, B> double[] computeBivariateRanks(NumberArrayAdapter<?, A> numberArrayAdapter, A a, NumberArrayAdapter<?, B> numberArrayAdapter2, B b, int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double d = numberArrayAdapter.getDouble(a, i);
                double d2 = numberArrayAdapter.getDouble(a, j);
                double d3 = numberArrayAdapter2.getDouble(b, i);
                double d4 = numberArrayAdapter2.getDouble(b, j);
                if (d < d2) {
                    int n2 = j;
                    dArray[n2] = dArray[n2] + (d3 < d4 ? 1.0 : (d3 == d4 ? 0.5 : 0.0));
                    continue;
                }
                if (d2 < d) {
                    int n3 = i;
                    dArray[n3] = dArray[n3] + (d4 < d3 ? 1.0 : (d4 == d3 ? 0.5 : 0.0));
                    continue;
                }
                if (d3 < d4) {
                    int n4 = j;
                    dArray[n4] = dArray[n4] + 0.5;
                    continue;
                }
                if (d4 < d3) {
                    int n5 = i;
                    dArray[n5] = dArray[n5] + 0.5;
                    continue;
                }
                int n6 = i;
                dArray[n6] = dArray[n6] + 0.25;
                int n7 = j;
                dArray[n7] = dArray[n7] + 0.25;
            }
        }
        return dArray;
    }

    public double toPValue(double d, int n) {
        double d2 = d / 30.0 + 1.0 / (double)(36 * n);
        double d3 = 48.704545517001215 * (double)n * d2;
        if (d3 < 1.1 || d3 > 8.5) {
            double d4 = Math.exp(0.3885037 - 1.164879 * d3);
            return d4 > 1.0 ? 1.0 : (d4 < 0.0 ? 0.0 : d4);
        }
        for (int i = 0; i < 86; ++i) {
            if (!(TABPOS[i] >= d3)) continue;
            if (TABPOS[i] == d3) {
                return TABVAL[i];
            }
            double d5 = TABPOS[i];
            double d6 = TABPOS[i - 1];
            double d7 = TABVAL[i];
            double d8 = TABVAL[i - 1];
            return d8 + (d7 - d8) * (d3 - d6) / (d5 - d6);
        }
        return -1.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HoeffdingsDDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

