/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.linearalgebra.fitting.GaussianFittingFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.fitting.LevenbergMarquardtMethod;
import de.lmu.ifi.dbs.elki.math.statistics.KernelDensityEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogNormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.GaussianKernelDensityFunction;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.Arrays;

public class LogNormalLevenbergMarquardtKDEEstimator
implements DistributionEstimator<LogNormalDistribution> {
    public static final LogNormalLevenbergMarquardtKDEEstimator STATIC = new LogNormalLevenbergMarquardtKDEEstimator();

    private LogNormalLevenbergMarquardtKDEEstimator() {
    }

    @Override
    public <A> LogNormalDistribution estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        MeanVariance meanVariance = new MeanVariance();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = numberArrayAdapter.getDouble(a, i);
            if (!(d > 0.0)) {
                throw new ArithmeticException("Cannot fit logNormal to a data set which includes non-positive values: " + d);
            }
            dArray[i] = Math.log(d);
            meanVariance.put(dArray[i]);
        }
        Arrays.sort(dArray);
        double d = (dArray[n >> 1] + dArray[n + 1 >> 1]) * 0.5;
        KernelDensityEstimator kernelDensityEstimator = new KernelDensityEstimator(dArray, GaussianKernelDensityFunction.KERNEL, 1.0E-6);
        double[] dArray2 = kernelDensityEstimator.getDensity();
        double[] dArray3 = new double[n];
        Arrays.fill(dArray3, 1.0);
        double[] dArray4 = new double[]{d, meanVariance.getSampleStddev(), 1.0};
        boolean[] blArray = new boolean[]{true, true, false};
        LevenbergMarquardtMethod levenbergMarquardtMethod = new LevenbergMarquardtMethod(GaussianFittingFunction.STATIC, dArray4, blArray, dArray, dArray2, dArray3);
        levenbergMarquardtMethod.run();
        double[] dArray5 = levenbergMarquardtMethod.getParams();
        return new LogNormalDistribution(dArray5[0], dArray5[1], 0.0);
    }

    @Override
    public Class<? super LogNormalDistribution> getDistributionClass() {
        return LogNormalDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogNormalLevenbergMarquardtKDEEstimator makeInstance() {
            return STATIC;
        }
    }
}

