/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.RayleighDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractMADEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(title="Applied Robust Statistics", authors="D. J. Olive", booktitle="Applied Robust Statistics", url="http://lagrange.math.siu.edu/Olive/preprints.htm")
public class RayleighMADEstimator
extends AbstractMADEstimator<RayleighDistribution> {
    public static final RayleighMADEstimator STATIC = new RayleighMADEstimator();
    private static final double F1 = 2.2298880819171685;
    private static final double F2 = 2.6254925265300937;

    private RayleighMADEstimator() {
    }

    @Override
    public RayleighDistribution estimateFromMedianMAD(double d, double d2) {
        return new RayleighDistribution(d - 2.6254925265300937 * d2, 2.2298880819171685 * d2);
    }

    @Override
    public Class<? super RayleighDistribution> getDistributionClass() {
        return RayleighDistribution.class;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected RayleighMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

