/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.UniformDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class UniformEnhancedMinMaxEstimator
implements DistributionEstimator<UniformDistribution> {
    public static final UniformEnhancedMinMaxEstimator STATIC = new UniformEnhancedMinMaxEstimator();

    private UniformEnhancedMinMaxEstimator() {
    }

    @Override
    public <A> UniformDistribution estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        for (int i = 0; i < n; ++i) {
            double d = numberArrayAdapter.getDouble(a, i);
            if (!(d > Double.NEGATIVE_INFINITY) || !(d < Double.POSITIVE_INFINITY)) continue;
            doubleMinMax.put(d);
        }
        return this.estimate(doubleMinMax.getMin(), doubleMinMax.getMax(), n);
    }

    public UniformDistribution estimate(double d, double d2, int n) {
        double d3 = n > 1 ? 0.5 * (d2 - d) / (double)(n - 1) : 0.0;
        return new UniformDistribution(Math.max(d - d3, -1.7976931348623157E308), Math.min(d2 + d3, Double.MAX_VALUE));
    }

    @Override
    public Class<? super UniformDistribution> getDistributionClass() {
        return UniformDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected UniformEnhancedMinMaxEstimator makeInstance() {
            return STATIC;
        }
    }
}

