/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions;

import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public final class TriangularKernelDensityFunction
implements KernelDensityFunction {
    public static final TriangularKernelDensityFunction KERNEL = new TriangularKernelDensityFunction();
    public static final double CANONICAL_BANDWIDTH = Math.pow(24.0, 0.2);
    private static final double STDDEV = 1.0 / Math.sqrt(6.0);
    private static final double R = 0.6666666666666666;

    private TriangularKernelDensityFunction() {
    }

    @Override
    public double density(double d) {
        return d < 1.0 ? 1.0 - d : 0.0;
    }

    @Override
    public double canonicalBandwidth() {
        return CANONICAL_BANDWIDTH;
    }

    @Override
    public double standardDeviation() {
        return STDDEV;
    }

    @Override
    public double getR() {
        return 0.6666666666666666;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected TriangularKernelDensityFunction makeInstance() {
            return KERNEL;
        }
    }
}

