/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.parallel;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ParallelCore {
    public static final int ALL_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private static final ParallelCore STATIC = new ParallelCore(ALL_PROCESSORS);
    ThreadPoolExecutor executor;
    private AtomicInteger connected = new AtomicInteger(0);
    private int processors;

    protected ParallelCore(int n) {
        this.processors = n;
    }

    public static ParallelCore getCore() {
        return STATIC;
    }

    public int getParallelism() {
        return this.executor.getMaximumPoolSize();
    }

    public <T> Future<T> submit(Callable<T> callable) {
        return this.executor.submit(callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        int n;
        if (this.executor == null) {
            ParallelCore parallelCore = this;
            synchronized (parallelCore) {
                if (this.executor == null) {
                    this.executor = new ThreadPoolExecutor(0, this.processors, 10L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
                    this.executor.allowCoreThreadTimeOut(true);
                }
            }
        }
        if ((n = this.connected.incrementAndGet()) == 1) {
            this.executor.allowCoreThreadTimeOut(false);
            this.executor.setCorePoolSize(this.executor.getMaximumPoolSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        int n = this.connected.decrementAndGet();
        if (n == 0) {
            ParallelCore parallelCore = this;
            synchronized (parallelCore) {
                this.executor.allowCoreThreadTimeOut(true);
                this.executor.setCorePoolSize(0);
            }
        }
    }
}

