/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHandler;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.VisualizerParameterizer;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.PlotItem;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@Alias(value={"de.lmu.ifi.dbs.elki.visualization.ExportVisualizations"})
public class ExportVisualizations
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(ExportVisualizations.class);
    File output;
    VisualizerParameterizer manager;
    double ratio;
    Result baseResult = null;
    VisualizerContext context = null;
    Map<String, Integer> counter = new HashMap<String, Integer>();

    public ExportVisualizations(File file, VisualizerParameterizer visualizerParameterizer, double d) {
        this.output = file;
        this.manager = visualizerParameterizer;
        this.ratio = d;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        VisualizationItem visualizationItem;
        if (this.output.isFile()) {
            throw new AbortException("Output folder cannot be an existing file.");
        }
        if (!this.output.exists() && !this.output.mkdirs()) {
            throw new AbortException("Could not create output directory.");
        }
        if (this.baseResult == null) {
            this.baseResult = result;
            this.context = null;
            this.counter = new HashMap<String, Integer>();
            LOG.warning("Note: Reusing visualization exporter for more than one result is untested.");
        }
        if (this.context == null) {
            this.context = this.manager.newContext(resultHierarchy, this.baseResult);
        }
        VisualizationTree visualizationTree = this.context.getVisHierarchy();
        Hierarchy.Iter iter = visualizationTree.iterAll();
        while (iter.valid()) {
            if (iter.get() instanceof Projector) {
                visualizationItem = (Projector)iter.get();
                Collection<PlotItem> collection = visualizationItem.arrange(this.context);
                for (PlotItem plotItem : collection) {
                    this.processItem(plotItem);
                }
            }
            iter.advance();
        }
        iter = visualizationTree.iterAll();
        while (iter.valid()) {
            if (iter.get() instanceof VisualizationTask) {
                visualizationItem = (VisualizationTask)iter.get();
                boolean bl = false;
                Object object = visualizationTree.iterParents(visualizationItem);
                while (object.valid()) {
                    if (object.get() instanceof Projector) {
                        bl = true;
                        break;
                    }
                    object.advance();
                }
                if (!bl) {
                    object = new PlotItem(this.ratio, 1.0, null);
                    ((PlotItem)object).add((VisualizationTask)visualizationItem);
                    this.processItem((PlotItem)object);
                }
            }
            iter.advance();
        }
    }

    private void processItem(PlotItem plotItem) {
        Object object;
        Iterator<PlotItem> iterator = plotItem.subitems.iterator();
        while (iterator.hasNext()) {
            this.processItem(iterator.next());
        }
        if (plotItem.taskSize() <= 0) {
            return;
        }
        plotItem.sort();
        double d = plotItem.w;
        double d2 = plotItem.h;
        VisualizationPlot visualizationPlot = new VisualizationPlot();
        visualizationPlot.getRoot().setAttribute("width", "20cm");
        visualizationPlot.getRoot().setAttribute("height", 20.0 * d2 / d + "cm");
        visualizationPlot.getRoot().setAttribute("viewBox", "0 0 " + d + " " + d2);
        ArrayList<Visualization> arrayList = new ArrayList<Visualization>();
        for (VisualizationTask object22 : plotItem.tasks) {
            if (object22.hasAnyFlags(6) || !object22.visible) continue;
            try {
                object = object22.getFactory().makeVisualization(object22, visualizationPlot, d, d2, plotItem.proj);
                arrayList.add((Visualization)object);
            }
            catch (Exception exception) {
                if (Logging.getLogger(object22.getFactory().getClass()).isDebugging()) {
                    LOG.exception("Visualization failed.", exception);
                    continue;
                }
                LOG.warning("Visualizer " + object22.getFactory().getClass().getName() + " failed - enable debugging to see details.");
            }
        }
        if (arrayList.size() <= 0) {
            return;
        }
        for (Visualization visualization : arrayList) {
            if (visualization.getLayer() == null) {
                LOG.warning("NULL layer seen.");
                continue;
            }
            visualizationPlot.getRoot().appendChild(visualization.getLayer());
        }
        visualizationPlot.updateStyleElement();
        Object object3 = null;
        object3 = object3 == null && plotItem.proj != null ? plotItem.proj.getMenuName() : object3;
        object3 = object3 == null && plotItem.tasks.size() > 0 ? plotItem.tasks.get(0).getMenuName() : object3;
        object3 = object3 != null ? object3 : "plot";
        Integer n2 = this.counter.get(object3);
        n2 = n2 == null ? 1 : n2 + 1;
        this.counter.put((String)object3, n2);
        object = new File(this.output, (String)object3 + "-" + n2 + ".svg");
        try {
            visualizationPlot.saveAsSVG((File)object);
        }
        catch (Exception exception) {
            LOG.warning("Export of visualization failed.", exception);
        }
        for (Visualization visualization : arrayList) {
            visualization.destroy();
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID RATIO_ID = new OptionID("vis.ratio", "The width/heigh ratio of the output.");
        public static final OptionID FOLDER_ID = new OptionID("vis.output", "The output folder.");
        VisualizerParameterizer manager;
        File output;
        double ratio;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            FileParameter fileParameter = new FileParameter(FOLDER_ID, FileParameter.FileType.OUTPUT_FILE);
            if (parameterization.grab(fileParameter)) {
                this.output = (File)fileParameter.getValue();
            }
            DoubleParameter doubleParameter = new DoubleParameter(RATIO_ID, 1.33);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.ratio = doubleParameter.doubleValue();
            }
            this.manager = parameterization.tryInstantiate(VisualizerParameterizer.class);
        }

        @Override
        protected ExportVisualizations makeInstance() {
            return new ExportVisualizations(this.output, this.manager, this.ratio);
        }
    }
}

