/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.arrays;

import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerComparator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="Vladimir Yaroslavskiy", title="Dual-Pivot Quicksort", booktitle="http://iaroslavski.narod.ru/quicksort/", url="http://iaroslavski.narod.ru/quicksort/")
public class IntegerArrayQuickSort {
    private static final int INSERTION_THRESHOLD = 47;

    public static void sort(int[] nArray, IntegerComparator integerComparator) {
        IntegerArrayQuickSort.sort(nArray, 0, nArray.length, integerComparator);
    }

    public static void sort(int[] nArray, int n, int n2, IntegerComparator integerComparator) {
        IntegerArrayQuickSort.quickSort(nArray, n, n2, integerComparator);
    }

    private static void quickSort(int[] nArray, int n, int n2, IntegerComparator integerComparator) {
        int n3 = n2 - n;
        int n4 = n2 - 1;
        if (n3 < 47) {
            IntegerArrayQuickSort.insertionSort(nArray, n, n2, integerComparator);
            return;
        }
        int n5 = (n3 >> 3) + (n3 >> 6) + 1;
        int n6 = n + n2 >> 1;
        int n7 = n6 - n5;
        int n8 = n7 - n5;
        int n9 = n6 + n5;
        int n10 = n9 + n5;
        IntegerArrayQuickSort.sort5(nArray, n8, n7, n6, n9, n10, integerComparator);
        int n11 = nArray[n7];
        int n12 = nArray[n9];
        nArray[n7] = nArray[n];
        nArray[n9] = nArray[n4];
        boolean bl = integerComparator.compare(n11, n12) == 0;
        int n13 = n + 1;
        int n14 = n4 - 1;
        for (int i = n13; i <= n14; ++i) {
            int n15;
            int n16 = nArray[i];
            int n17 = integerComparator.compare(n16, n11);
            if (n17 == 0) continue;
            if (n17 < 0) {
                nArray[i] = nArray[n13];
                nArray[n13] = n16;
                ++n13;
                continue;
            }
            if (!bl && integerComparator.compare(n16, n12) <= 0) continue;
            while (integerComparator.compare(n15 = nArray[n14], n12) > 0 && i < n14) {
                --n14;
            }
            nArray[i] = nArray[n14];
            nArray[n14] = n16;
            --n14;
            if (integerComparator.compare(nArray[i], n11) >= 0) continue;
            n15 = nArray[i];
            nArray[i] = nArray[n13];
            nArray[n13] = n15;
            ++n13;
        }
        nArray[n] = nArray[n13 - 1];
        nArray[n13 - 1] = n11;
        nArray[n4] = nArray[n14 + 1];
        nArray[n14 + 1] = n12;
        IntegerArrayQuickSort.quickSort(nArray, n, n13 - 1, integerComparator);
        if (!bl) {
            IntegerArrayQuickSort.quickSort(nArray, n13, n14 + 1, integerComparator);
        }
        IntegerArrayQuickSort.quickSort(nArray, n14 + 2, n2, integerComparator);
    }

    private static void insertionSort(int[] nArray, int n, int n2, IntegerComparator integerComparator) {
        for (int i = n + 1; i < n2; ++i) {
            int n3;
            int n4 = nArray[i];
            for (int j = i - 1; j >= n && integerComparator.compare(n4, n3 = nArray[j]) < 0; --j) {
                nArray[j + 1] = n3;
            }
            nArray[j + 1] = n4;
        }
    }

    private static void sort5(int[] nArray, int n, int n2, int n3, int n4, int n5, IntegerComparator integerComparator) {
        int n6;
        if (integerComparator.compare(nArray[n], nArray[n2]) > 0) {
            n6 = nArray[n2];
            nArray[n2] = nArray[n];
            nArray[n] = n6;
        }
        if (integerComparator.compare(nArray[n3], nArray[n4]) > 0) {
            n6 = nArray[n4];
            nArray[n4] = nArray[n3];
            nArray[n3] = n6;
        }
        if (integerComparator.compare(nArray[n2], nArray[n4]) > 0) {
            n6 = nArray[n4];
            nArray[n4] = nArray[n2];
            nArray[n2] = n6;
        }
        if (integerComparator.compare(nArray[n], nArray[n3]) > 0) {
            n6 = nArray[n3];
            nArray[n3] = nArray[n];
            nArray[n] = n6;
        }
        if (integerComparator.compare(nArray[n2], nArray[n3]) > 0) {
            n6 = nArray[n3];
            nArray[n3] = nArray[n2];
            nArray[n2] = n6;
        }
        if (integerComparator.compare(nArray[n4], n6 = nArray[n5]) > 0) {
            nArray[n5] = nArray[n4];
            nArray[n4] = n6;
            if (integerComparator.compare(nArray[n3], n6) > 0) {
                nArray[n4] = nArray[n3];
                nArray[n3] = n6;
                if (integerComparator.compare(nArray[n2], n6) > 0) {
                    nArray[n3] = nArray[n2];
                    nArray[n2] = n6;
                    if (integerComparator.compare(nArray[n], n6) > 0) {
                        nArray[n2] = nArray[n];
                        nArray[n] = n6;
                    }
                }
            }
        }
    }
}

