/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.histogram;

import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.ShortHistogram;
import java.util.Arrays;

public class ShortStaticHistogram
extends AbstractStaticHistogram
implements ShortHistogram {
    short[] data;

    public ShortStaticHistogram(int n, double d, double d2) {
        super(n, d, d2);
        this.data = (short[])(n >= 0 ? new short[n] : null);
    }

    @Override
    public void increment(double d, short s) {
        int n = this.getBinNr(d);
        if (n < 0) {
            if (this.size - n > this.data.length) {
                short[] sArray = new short[ShortStaticHistogram.growSize(this.data.length, this.size - n)];
                System.arraycopy(this.data, 0, sArray, -n, this.size);
                this.data = sArray;
            } else {
                System.arraycopy(this.data, 0, this.data, -n, this.size);
                Arrays.fill(this.data, 0, -n, (short)0);
            }
            this.data[0] = s;
            assert (this.data.length >= this.size - n);
            this.offset -= n;
            this.size -= n;
        } else if (n >= this.data.length) {
            short[] sArray = new short[ShortStaticHistogram.growSize(this.data.length, n + 1)];
            System.arraycopy(this.data, 0, sArray, 0, this.size);
            sArray[n] = s;
            this.data = sArray;
            this.size = n + 1;
            this.max = Double.MAX_VALUE;
        } else {
            if (n >= this.size) {
                this.size = n + 1;
            }
            int n2 = n;
            this.data[n2] = (short)(this.data[n2] + s);
        }
    }

    public short get(double d) {
        int n = this.getBinNr(d);
        if (n < 0 || n >= this.size) {
            return 0;
        }
        return this.data[n];
    }

    @Override
    public Iter iter() {
        return new Iter();
    }

    public class Iter
    extends AbstractStaticHistogram.Iter
    implements ShortHistogram.Iter {
        public Iter() {
            super(ShortStaticHistogram.this);
        }

        @Override
        public short getValue() {
            return ShortStaticHistogram.this.data[this.bin];
        }
    }
}

