/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.AbstractNumberConstraint;

public class LessEqualConstraint
extends AbstractNumberConstraint<Number> {
    public LessEqualConstraint(Number number) {
        super(number);
    }

    public LessEqualConstraint(double d) {
        super(d);
    }

    public LessEqualConstraint(int n) {
        super(n);
    }

    @Override
    public void test(Number number) throws ParameterException {
        if (number.doubleValue() > this.constraintValue.doubleValue()) {
            throw new WrongParameterValueException("Parameter Constraint Error: \nThe parameter value specified has to be less equal than " + this.constraintValue.toString() + ". (current value: " + number.doubleValue() + ")\n");
        }
    }

    @Override
    public String getDescription(String string) {
        return string + " <= " + this.constraintValue;
    }
}

