/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;
import java.io.File;
import java.io.IOException;

public class FileParameter
extends AbstractParameter<FileParameter, File> {
    private FileType fileType;

    public FileParameter(OptionID optionID, FileType fileType) {
        super(optionID);
        this.fileType = fileType;
    }

    public FileParameter(OptionID optionID, FileType fileType, boolean bl) {
        this(optionID, fileType);
        this.setOptional(bl);
    }

    @Override
    public String getValueAsString() {
        try {
            return ((File)this.getValue()).getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    protected File parseValue(Object object) throws ParameterException {
        if (object == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (object instanceof File) {
            return (File)object;
        }
        if (object instanceof String) {
            return new File((String)object);
        }
        throw new WrongParameterValueException("Parameter \"" + this.getName() + "\": Unsupported value given!");
    }

    @Override
    protected boolean validate(File file) throws ParameterException {
        if (!super.validate(file)) {
            return false;
        }
        if (this.fileType.equals((Object)FileType.INPUT_FILE)) {
            try {
                if (!file.exists()) {
                    throw new WrongParameterValueException("Given file " + file.getPath() + " for parameter \"" + this.getName() + "\" does not exist!\n");
                }
            }
            catch (SecurityException securityException) {
                throw new WrongParameterValueException("Given file \"" + file.getPath() + "\" cannot be read, access denied!\n" + securityException.getMessage());
            }
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return "<file>";
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public static enum FileType {
        INPUT_FILE,
        OUTPUT_FILE;

    }
}

