/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.StandardDeviationScaling;

@Reference(authors="H.-P. Kriegel, P. Kr\u00f6ger, E. Schubert, A. Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM), Mesa, AZ, 2011", url="http://dx.doi.org/10.1137/1.9781611972818.2")
public class MinusLogStandardDeviationScaling
extends StandardDeviationScaling {
    public MinusLogStandardDeviationScaling(Double d, Double d2) {
        super(d, d2);
    }

    @Override
    public double getScaled(double d) {
        assert (this.factor != 0.0) : "prepare() was not run prior to using the scaling function.";
        double d2 = -Math.log(d);
        if (d2 < this.mean || Double.isNaN(d2)) {
            return 0.0;
        }
        return Math.max(0.0, NormalDistribution.erf((d2 - this.mean) / this.factor));
    }

    @Override
    public void prepare(OutlierResult outlierResult) {
        if (this.fixedmean == null) {
            MeanVariance meanVariance = new MeanVariance();
            DoubleRelation doubleRelation = outlierResult.getScores();
            DBIDIter dBIDIter = doubleRelation.iterDBIDs();
            while (dBIDIter.valid()) {
                double d = -Math.log(doubleRelation.doubleValue(dBIDIter));
                if (!Double.isNaN(d) && !Double.isInfinite(d)) {
                    meanVariance.put(d);
                }
                dBIDIter.advance();
            }
            this.mean = meanVariance.getMean();
            this.factor = this.lambda * meanVariance.getSampleStddev() * MathUtil.SQRT2;
        } else {
            this.mean = this.fixedmean;
            Mean mean = new Mean();
            DoubleRelation doubleRelation = outlierResult.getScores();
            DBIDIter dBIDIter = doubleRelation.iterDBIDs();
            while (dBIDIter.valid()) {
                double d = -Math.log(doubleRelation.doubleValue(dBIDIter));
                if (!Double.isNaN(d) && !Double.isInfinite(d)) {
                    mean.put((d - this.mean) * (d - this.mean));
                }
                dBIDIter.advance();
            }
            this.factor = this.lambda * Math.sqrt(mean.getMean()) * MathUtil.SQRT2;
        }
    }

    public static class Parameterizer
    extends StandardDeviationScaling.Parameterizer {
        @Override
        protected MinusLogStandardDeviationScaling makeInstance() {
            return new MinusLogStandardDeviationScaling(this.fixedmean, (Double)this.lambda);
        }
    }
}

