/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;
import java.util.Arrays;

public class RankingPseudoOutlierScaling
implements OutlierScalingFunction {
    private double[] scores;
    private boolean inverted = false;

    @Override
    public void prepare(OutlierResult outlierResult) {
        DoubleRelation doubleRelation = outlierResult.getScores();
        this.scores = new double[doubleRelation.size()];
        int n = 0;
        if (outlierResult.getOutlierMeta() instanceof InvertedOutlierScoreMeta) {
            this.inverted = true;
        }
        DBIDIter dBIDIter = doubleRelation.iterDBIDs();
        while (dBIDIter.valid()) {
            this.scores[n] = doubleRelation.doubleValue(dBIDIter);
            ++n;
            dBIDIter.advance();
        }
        if (n != doubleRelation.size()) {
            throw new AbortException("Database size is incorrect!");
        }
        Arrays.sort(this.scores);
    }

    @Override
    public <A> void prepare(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        this.scores = ArrayLikeUtil.toPrimitiveDoubleArray(a, numberArrayAdapter);
        Arrays.sort(this.scores);
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getScaled(double d) {
        int n;
        int n2;
        assert (this.scores != null) : "prepare() was not run prior to using the scaling function.";
        int n3 = n2;
        for (n = n2 = Arrays.binarySearch(this.scores, d); n > 0 && this.scores[n - 1] == d; --n) {
        }
        while (n3 + 1 < this.scores.length && this.scores[n3 + 1] == d) {
            ++n3;
        }
        double d2 = (double)(n + n3) * 0.5 / ((double)this.scores.length - 1.0);
        return this.inverted ? 1.0 - d2 : d2;
    }
}

