/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.MeanVarianceMinMax;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;

@Reference(authors="H.-P. Kriegel, P. Kr\u00f6ger, E. Schubert, A. Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM), Mesa, AZ, 2011", url="http://dx.doi.org/10.1137/1.9781611972818.2")
public class SqrtStandardDeviationScaling
implements OutlierScalingFunction {
    double min;
    double mean;
    double factor;
    Double pmin = null;
    Double pmean = null;
    double plambda;

    public SqrtStandardDeviationScaling(Double d, Double d2, double d3) {
        this.pmin = d;
        this.pmean = d2;
        this.plambda = d3;
    }

    @Override
    public double getScaled(double d) {
        assert (this.factor != 0.0) : "prepare() was not run prior to using the scaling function.";
        if (d <= this.min) {
            return 0.0;
        }
        double d2 = d = d <= this.min ? 0.0 : Math.sqrt(d - this.min);
        if (d <= this.mean) {
            return 0.0;
        }
        return Math.max(0.0, NormalDistribution.erf((d - this.mean) / this.factor));
    }

    @Override
    public void prepare(OutlierResult outlierResult) {
        if (this.pmean == null) {
            MeanVarianceMinMax meanVarianceMinMax = new MeanVarianceMinMax();
            DoubleRelation doubleRelation = outlierResult.getScores();
            DBIDIter dBIDIter = doubleRelation.iterDBIDs();
            while (dBIDIter.valid()) {
                double d = doubleRelation.doubleValue(dBIDIter);
                d = d <= this.min ? 0.0 : Math.sqrt(d - this.min);
                meanVarianceMinMax.put(d);
                dBIDIter.advance();
            }
            this.min = this.pmin == null ? meanVarianceMinMax.getMin() : this.pmin.doubleValue();
            this.mean = meanVarianceMinMax.getMean();
            this.factor = this.plambda * meanVarianceMinMax.getSampleStddev() * MathUtil.SQRT2;
        } else {
            this.mean = this.pmean;
            double d = 0.0;
            int n = 0;
            DoubleRelation doubleRelation = outlierResult.getScores();
            double d2 = Double.POSITIVE_INFINITY;
            DBIDIter dBIDIter = doubleRelation.iterDBIDs();
            while (dBIDIter.valid()) {
                double d3 = doubleRelation.doubleValue(dBIDIter);
                d2 = Math.min(d2, d3);
                d3 = d3 <= this.min ? 0.0 : Math.sqrt(d3 - this.min);
                d += (d3 - this.mean) * (d3 - this.mean);
                ++n;
                dBIDIter.advance();
            }
            this.min = this.pmin == null ? d2 : this.pmin;
            this.factor = this.plambda * Math.sqrt(d / (double)n) * MathUtil.SQRT2;
        }
    }

    @Override
    public <A> void prepare(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        if (this.pmean == null) {
            MeanVarianceMinMax meanVarianceMinMax = new MeanVarianceMinMax();
            int n = numberArrayAdapter.size(a);
            for (int i = 0; i < n; ++i) {
                double d = numberArrayAdapter.getDouble(a, i);
                d = d <= this.min ? 0.0 : Math.sqrt(d - this.min);
                meanVarianceMinMax.put(d);
            }
            this.min = this.pmin == null ? meanVarianceMinMax.getMin() : this.pmin.doubleValue();
            this.mean = meanVarianceMinMax.getMean();
            this.factor = this.plambda * meanVarianceMinMax.getSampleStddev() * MathUtil.SQRT2;
        } else {
            this.mean = this.pmean;
            Mean mean = new Mean();
            double d = Double.POSITIVE_INFINITY;
            int n = numberArrayAdapter.size(a);
            for (int i = 0; i < n; ++i) {
                double d2 = numberArrayAdapter.getDouble(a, i);
                d = Math.min(d, d2);
                d2 = d2 <= this.min ? 0.0 : Math.sqrt(d2 - this.min);
                mean.put((d2 - this.mean) * (d2 - this.mean));
            }
            this.min = this.pmin == null ? d : this.pmin;
            this.factor = this.plambda * Math.sqrt(mean.getMean()) * MathUtil.SQRT2;
        }
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MIN_ID = new OptionID("sqrtstddevscale.min", "Fixed minimum to use in sqrt scaling.");
        public static final OptionID MEAN_ID = new OptionID("sqrtstddevscale.mean", "Fixed mean to use in standard deviation scaling.");
        public static final OptionID LAMBDA_ID = new OptionID("sqrtstddevscale.lambda", "Significance level to use for error function.");
        protected Double min = null;
        protected Double mean = null;
        protected double lambda;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(MIN_ID);
            doubleParameter2.setOptional(true);
            if (parameterization.grab(doubleParameter2)) {
                this.min = doubleParameter2.doubleValue();
            }
            DoubleParameter doubleParameter3 = new DoubleParameter(MEAN_ID);
            doubleParameter3.setOptional(true);
            if (parameterization.grab(doubleParameter3)) {
                this.mean = doubleParameter3.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(LAMBDA_ID, 3.0))) {
                this.lambda = doubleParameter.doubleValue();
            }
        }

        @Override
        protected SqrtStandardDeviationScaling makeInstance() {
            return new SqrtStandardDeviationScaling(this.min, this.mean, this.lambda);
        }
    }
}

