/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.xml;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class HTMLUtil {
    public static final String HTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    public static final String HTML_XHTML_TRANSITIONAL_DOCTYPE_PUBLIC = "-//W3C//DTD XHTML 1.0 Transitional//EN";
    public static final String HTML_XHTML_TRANSITIONAL_DOCTYPE_SYSTEM = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
    public static final String HTML_HTML_TAG = "html";
    public static final String HTML_HEAD_TAG = "head";
    public static final String HTML_TITLE_TAG = "title";
    public static final String HTML_BODY_TAG = "body";
    public static final String HTML_DL_TAG = "dl";
    public static final String HTML_DT_TAG = "dt";
    public static final String HTML_DD_TAG = "dd";
    public static final String HTML_UL_TAG = "ul";
    public static final String HTML_OL_TAG = "ol";
    public static final String HTML_LI_TAG = "li";
    public static final String HTML_EM_TAG = "em";
    public static final String HTML_I_TAG = "i";
    public static final String HTML_STRONG_TAG = "strong";
    public static final String HTML_B_TAG = "b";
    public static final String HTML_TT_TAG = "tt";
    public static final String HTML_BR_TAG = "br";
    public static final String HTML_H1_TAG = "h1";
    public static final String HTML_A_TAG = "a";
    public static final String HTML_P_TAG = "p";
    public static final String HTML_DIV_TAG = "div";
    public static final String HTML_SPAN_TAG = "span";
    public static final String HTML_IMG_TAG = "img";
    public static final String HTML_META_TAG = "meta";
    public static final String HTML_LINK_TAG = "link";
    public static final String HTML_HREF_ATTRIBUTE = "href";
    public static final String HTML_SRC_ATTRIBUTE = "src";
    public static final String HTML_STYLE_ATTRIBUTE = "style";
    public static final String HTML_CLASS_ATTRIBUTE = "class";
    public static final String HTML_NAME_ATTRIBUTE = "name";
    public static final String HTML_TYPE_ATTRIBUTE = "type";
    public static final String HTML_REL_ATTRIBUTE = "rel";
    public static final String HTML_REL_STYLESHEET = "stylesheet";
    public static final String HTML_HTTP_EQUIV_ATTRIBUTE = "http-equiv";
    public static final String HTML_CONTENT_ATTRIBUTE = "content";
    public static final String HTML_HTTP_EQUIV_CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TYPE_HTML = "text/html";
    public static final String CONTENT_TYPE_CSS = "text/css";
    public static final String CONTENT_TYPE_HTML_UTF8 = "text/html; charset=UTF-8";

    public static void writeXHTML(Document document, OutputStream outputStream) throws IOException {
        StreamResult streamResult = new StreamResult(outputStream);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("doctype-public", HTML_XHTML_TRANSITIONAL_DOCTYPE_PUBLIC);
            transformer.setOutputProperty("doctype-system", HTML_XHTML_TRANSITIONAL_DOCTYPE_SYSTEM);
            transformer.transform(new DOMSource(document), streamResult);
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
        outputStream.flush();
    }

    public static void appendMultilineText(Document document, Element element, String string) {
        boolean bl = true;
        for (String string2 : string.split("\n")) {
            if (!bl) {
                element.appendChild(document.createElement(HTML_BR_TAG));
            }
            element.appendChild(document.createTextNode(string2));
            bl = false;
        }
    }
}

