/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.css;

import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import java.util.Collection;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class CSSClassManager {
    private HashMap<String, CSSClass> store = new HashMap();

    public CSSClass addClass(CSSClass cSSClass) throws CSSNamingConflict {
        CSSClass cSSClass2 = this.store.get(cSSClass.getName());
        if (cSSClass2 != null && cSSClass2.getOwner() != null && cSSClass2.getOwner() != cSSClass.getOwner()) {
            throw new CSSNamingConflict("CSS class naming conflict between " + cSSClass.getOwner().toString() + " and " + cSSClass2.getOwner().toString());
        }
        return this.store.put(cSSClass.getName(), cSSClass);
    }

    public synchronized void removeClass(CSSClass cSSClass) {
        CSSClass cSSClass2 = this.store.get(cSSClass.getName());
        if (cSSClass2 == cSSClass) {
            this.store.remove(cSSClass2.getName());
        }
    }

    public CSSClass getClass(String string, Object object) throws CSSNamingConflict {
        CSSClass cSSClass = this.store.get(string);
        if (cSSClass == null) {
            return null;
        }
        if (object != null && cSSClass.getOwner() != object) {
            throw new CSSNamingConflict("CSS class naming conflict between " + object.toString() + " and " + cSSClass.getOwner().toString());
        }
        return cSSClass;
    }

    public CSSClass getClass(String string) {
        return this.store.get(string);
    }

    public boolean contains(String string) {
        return this.store.containsKey(string);
    }

    public void serialize(StringBuilder stringBuilder) {
        for (CSSClass cSSClass : this.store.values()) {
            cSSClass.appendCSSDefinition(stringBuilder);
        }
    }

    public Collection<CSSClass> getClasses() {
        return this.store.values();
    }

    public boolean testMergeable(CSSClassManager cSSClassManager) {
        for (CSSClass cSSClass : cSSClassManager.getClasses()) {
            CSSClass cSSClass2 = this.store.get(cSSClass.getName());
            if (cSSClass2 == null || cSSClass2.getOwner() == null || cSSClass.getOwner() == null || cSSClass2.getOwner() == cSSClass.getOwner()) continue;
            return false;
        }
        return true;
    }

    public boolean mergeCSSFrom(CSSClassManager cSSClassManager) throws CSSNamingConflict {
        for (CSSClass cSSClass : cSSClassManager.getClasses()) {
            this.addClass(cSSClass);
        }
        return true;
    }

    public void updateStyleElement(Document document, Element element) {
        StringBuilder stringBuilder = new StringBuilder();
        this.serialize(stringBuilder);
        Text text = document.createTextNode(stringBuilder.toString());
        while (element.hasChildNodes()) {
            element.removeChild(element.getFirstChild());
        }
        element.appendChild(text);
    }

    public Element makeStyleElement(Document document) {
        Element element = SVGUtil.makeStyleElement(document);
        this.updateStyleElement(document, element);
        return element;
    }

    public class CSSNamingConflict
    extends Exception {
        private static final long serialVersionUID = 4163822727195636747L;

        public CSSNamingConflict(String string) {
            super(string);
        }
    }
}

