/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.gui.overview;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationListener;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.CSSHoverClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.gui.detail.DetailView;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.DetailViewSelectedEvent;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.LayerMap;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.PlotItem;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.RectangleArranger;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGEffects;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class OverviewPlot
implements ResultListener,
VisualizationListener {
    private static final Logging LOG = Logging.getLogger(OverviewPlot.class);
    public static final String OVERVIEW_REFRESHING = "Overview refreshing";
    public static final String OVERVIEW_REFRESHED = "Overview refreshed";
    private static final boolean DEBUG_LAYOUT = false;
    private VisualizerContext context;
    private VisualizationPlot plot;
    protected RectangleArranger<PlotItem> plotmap;
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    private boolean single;
    public int screenwidth = 2000;
    public int screenheight = 2000;
    private EventListener hoverer;
    private LayerMap vistoelem = new LayerMap();
    private Element plotlayer;
    private Element hoverlayer;
    private CSSClass selcss;
    private double ratio = 1.0;
    AtomicReference<Runnable> pendingRefresh = new AtomicReference<Object>(null);
    private boolean reinitOnRefresh = false;

    public OverviewPlot(VisualizerContext visualizerContext, boolean bl) {
        this.context = visualizerContext;
        this.single = bl;
    }

    private RectangleArranger<PlotItem> arrangeVisualizations(double d, double d2) {
        Object object;
        VisualizationItem visualizationItem;
        if (!(d > 0.0) || !(d2 > 0.0)) {
            LOG.warning("No size information during arrange()", new Throwable());
            return new RectangleArranger<PlotItem>(1.0, 1.0);
        }
        RectangleArranger<PlotItem> rectangleArranger = new RectangleArranger<PlotItem>(d, d2);
        VisualizationTree visualizationTree = this.context.getVisHierarchy();
        Hierarchy.Iter iter = visualizationTree.iterAll();
        while (iter.valid()) {
            if (iter.get() instanceof Projector) {
                visualizationItem = (Projector)iter.get();
                object = visualizationItem.arrange(this.context);
                Iterator<PlotItem> iterator = object.iterator();
                while (iterator.hasNext()) {
                    PlotItem plotItem = iterator.next();
                    if (plotItem.w <= 0.0 || plotItem.h <= 0.0) {
                        LOG.warning("Plot item with improper size information: " + plotItem);
                        continue;
                    }
                    rectangleArranger.put(plotItem.w, plotItem.h, plotItem);
                }
            }
            iter.advance();
        }
        iter = visualizationTree.iterAll();
        while (iter.valid()) {
            block12: {
                if (iter.get() instanceof VisualizationTask) {
                    visualizationItem = (VisualizationTask)iter.get();
                    if (((VisualizationTask)visualizationItem).visible) {
                        object = visualizationTree.iterParents(visualizationItem);
                        while (object.valid()) {
                            if (!(object.get() instanceof Projector)) {
                                object.advance();
                                continue;
                            }
                            break block12;
                        }
                        if (((VisualizationTask)visualizationItem).reqwidth <= 0.0 || ((VisualizationTask)visualizationItem).reqheight <= 0.0) {
                            LOG.warning("Task with improper size information: " + visualizationItem);
                        } else {
                            object = new PlotItem(((VisualizationTask)visualizationItem).reqwidth, ((VisualizationTask)visualizationItem).reqheight, null);
                            ((PlotItem)object).tasks.add((VisualizationTask)visualizationItem);
                            rectangleArranger.put(((PlotItem)object).w, ((PlotItem)object).h, (PlotItem)object);
                        }
                    }
                }
            }
            iter.advance();
        }
        return rectangleArranger;
    }

    public void initialize(double d) {
        if (!(d > 0.0) || !(d < Double.POSITIVE_INFINITY)) {
            LOG.warning("Invalid ratio: " + d, new Throwable());
            d = 1.4;
        }
        this.ratio = d;
        if (this.plot != null) {
            LOG.warning("Already initialized.");
            this.lazyRefresh();
            return;
        }
        this.reinitialize();
        this.context.addResultListener(this);
        this.context.addVisualizationListener(this);
    }

    private synchronized void reinitialize() {
        if (this.plot == null) {
            this.initializePlot();
        } else {
            ActionEvent actionEvent = new ActionEvent(this, 1001, OVERVIEW_REFRESHING);
            for (ActionListener actionListener : this.actionListeners) {
                actionListener.actionPerformed(actionEvent);
            }
        }
        for (Pair pair : this.vistoelem.values()) {
            SVGUtil.removeFromParent((Element)pair.first);
        }
        this.plotmap = this.arrangeVisualizations(this.ratio, 1.0);
        this.recalcViewbox();
        int n = (int)Math.max((double)this.screenwidth / this.plotmap.getWidth(), (double)this.screenheight / this.plotmap.getHeight());
        LayerMap layerMap = this.vistoelem;
        this.vistoelem = new LayerMap();
        SVGUtil.removeFromParent(this.plotlayer);
        SVGUtil.removeFromParent(this.hoverlayer);
        this.plotlayer = this.plot.svgElement("g");
        this.hoverlayer = this.plot.svgElement("g");
        this.hoverlayer.setAttribute("noexport", "noexport");
        for (Map.Entry<PlotItem, double[]> entry : this.plotmap.entrySet()) {
            double d = entry.getValue()[0];
            double d2 = entry.getValue()[1];
            Iterator<PlotItem> iterator = entry.getKey().itemIterator();
            while (iterator.hasNext()) {
                PlotItem plotItem = iterator.next();
                boolean bl = false;
                Element element = this.plot.svgElement("g");
                SVGUtil.setAtt(element, "transform", "translate(" + (d + plotItem.x) + " " + (d2 + plotItem.y) + ")");
                this.plotlayer.appendChild(element);
                this.vistoelem.put(plotItem, null, element, null);
                for (VisualizationTask visualizationTask : plotItem.tasks) {
                    if (!this.visibleInOverview(visualizationTask)) continue;
                    bl |= !visualizationTask.hasAnyFlags(2);
                    Pair<Element, Visualization> pair = layerMap.remove(plotItem, visualizationTask);
                    if (pair == null) {
                        pair = new Pair<Object, Object>(null, null);
                        pair.first = this.plot.svgElement("g");
                    }
                    if (pair.second == null) {
                        pair.second = this.embedOrThumbnail(n, plotItem, visualizationTask, (Element)pair.first);
                    }
                    element.appendChild((Node)pair.first);
                    this.vistoelem.put(plotItem, visualizationTask, pair);
                }
                if (!bl || this.single) continue;
                Element element2 = this.plot.svgRect(d + plotItem.x, d2 + plotItem.y, plotItem.w, plotItem.h);
                SVGUtil.addCSSClass(element2, this.selcss.getName());
                EventTarget eventTarget = (EventTarget)((Object)element2);
                eventTarget.addEventListener("mouseover", this.hoverer, false);
                eventTarget.addEventListener("mouseout", this.hoverer, false);
                eventTarget.addEventListener("click", this.hoverer, false);
                eventTarget.addEventListener("click", new SelectPlotEvent(plotItem), false);
                this.hoverlayer.appendChild(element2);
            }
        }
        for (Pair<Element, Visualization> pair : layerMap.values()) {
            if (pair.second == null) continue;
            ((Visualization)pair.second).destroy();
        }
        this.plot.getRoot().appendChild(this.plotlayer);
        this.plot.getRoot().appendChild(this.hoverlayer);
        this.plot.updateStyleElement();
        ActionEvent actionEvent = new ActionEvent(this, 1001, OVERVIEW_REFRESHED);
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    private void initializePlot() {
        this.plot = new VisualizationPlot();
        CSSClass cSSClass = new CSSClass(this, "background");
        String string = this.context.getStyleLibrary().getBackgroundColor("page");
        cSSClass.setStatement("fill", string);
        this.plot.addCSSClassOrLogError(cSSClass);
        Element element = this.plot.svgElement("rect");
        element.setAttribute("x", "0");
        element.setAttribute("y", "0");
        element.setAttribute("width", "100%");
        element.setAttribute("height", "100%");
        SVGUtil.setCSSClass(element, cSSClass.getName());
        if ("white".equals(string)) {
            element.setAttribute("noexport", "noexport");
        }
        this.plot.getRoot().appendChild(element);
        this.selcss = new CSSClass(this, "s");
        this.selcss.setStatement("fill", "red");
        this.selcss.setStatement("fill-opacity", "0");
        this.selcss.setStatement("cursor", "pointer");
        this.plot.addCSSClassOrLogError(this.selcss);
        cSSClass = new CSSClass(this, "h");
        cSSClass.setStatement("fill-opacity", "0.25");
        this.plot.addCSSClassOrLogError(cSSClass);
        this.hoverer = new CSSHoverClass(cSSClass.getName(), null, true);
        if (this.single) {
            this.plot.setDisableInteractions(true);
        }
        SVGEffects.addShadowFilter(this.plot);
        SVGEffects.addLightGradient(this.plot);
    }

    private Visualization embedOrThumbnail(int n, PlotItem plotItem, VisualizationTask visualizationTask, Element element) {
        Visualization visualization = !this.single ? visualizationTask.getFactory().makeVisualizationOrThumbnail(visualizationTask, this.plot, plotItem.w, plotItem.h, plotItem.proj, n) : visualizationTask.getFactory().makeVisualization(visualizationTask, this.plot, plotItem.w, plotItem.h, plotItem.proj);
        if (visualization == null || visualization.getLayer() == null) {
            LoggingUtil.warning("Visualization returned empty layer: " + visualization);
            return visualization;
        }
        if (visualizationTask.hasAnyFlags(4)) {
            visualization.getLayer().setAttribute("noexport", "noexport");
        }
        element.appendChild(visualization.getLayer());
        return visualization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void refresh() {
        if (this.reinitOnRefresh) {
            LOG.debug("Reinitialize in thread " + Thread.currentThread().getName());
            this.reinitialize();
            this.reinitOnRefresh = false;
            return;
        }
        VisualizationPlot visualizationPlot = this.plot;
        synchronized (visualizationPlot) {
            boolean bl = false;
            if (this.plotmap == null) {
                LOG.warning("Plotmap is null", new Throwable());
            }
            int n = (int)Math.max((double)this.screenwidth / this.plotmap.getWidth(), (double)this.screenheight / this.plotmap.getHeight());
            for (PlotItem plotItem : this.plotmap.keySet()) {
                Iterator<PlotItem> iterator = plotItem.itemIterator();
                while (iterator.hasNext()) {
                    PlotItem plotItem2 = iterator.next();
                    for (VisualizationTask visualizationTask : plotItem2.tasks) {
                        Pair<Element, Visualization> pair = this.vistoelem.get(plotItem2, visualizationTask);
                        if (pair == null) {
                            if (!this.visibleInOverview(visualizationTask)) continue;
                            pair = new Pair<Object, Object>(null, null);
                            pair.first = this.plot.svgElement("g");
                            pair.second = this.embedOrThumbnail(n, plotItem2, visualizationTask, (Element)pair.first);
                            ((Element)this.vistoelem.get((PlotItem)plotItem2, null).first).appendChild((Node)pair.first);
                            this.vistoelem.put(plotItem2, visualizationTask, pair);
                            bl = true;
                            continue;
                        }
                        if (this.visibleInOverview(visualizationTask)) {
                            if (!((Element)pair.first).hasAttribute("visibility")) continue;
                            ((Element)pair.first).removeAttribute("visibility");
                            continue;
                        }
                        if (pair.first == null || !((Element)pair.first).hasChildNodes()) continue;
                        ((Element)pair.first).setAttribute("visibility", "hidden");
                    }
                }
            }
            if (bl) {
                this.plot.updateStyleElement();
            }
        }
    }

    protected boolean visibleInOverview(VisualizationTask visualizationTask) {
        if (this.single) {
            return visualizationTask.visible && !visualizationTask.hasAnyFlags(8);
        }
        return visualizationTask.visible && !visualizationTask.hasAnyFlags(1);
    }

    private void recalcViewbox() {
        Element element = this.plot.getRoot();
        SVGUtil.setAtt(element, "width", "20cm");
        SVGUtil.setAtt(element, "height", SVGUtil.fmt(20.0 * this.plotmap.getHeight() / this.plotmap.getWidth()) + "cm");
        String string = "0 0 " + SVGUtil.fmt(this.plotmap.getWidth()) + " " + SVGUtil.fmt(this.plotmap.getHeight());
        SVGUtil.setAtt(element, "viewBox", string);
    }

    public DetailView makeDetailView(PlotItem plotItem) {
        return new DetailView(this.context, plotItem, this.ratio);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    protected void triggerSubplotSelectEvent(PlotItem plotItem) {
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(new DetailViewSelectedEvent(this, 1001, null, 0, plotItem));
        }
    }

    public void destroy() {
        this.context.removeVisualizationListener(this);
        this.context.removeResultListener(this);
        this.plot.dispose();
    }

    public SVGPlot getPlot() {
        return this.plot;
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double d) {
        if (d != this.ratio) {
            this.ratio = d;
            this.reinitOnRefresh = true;
            this.lazyRefresh();
        }
    }

    public final void lazyRefresh() {
        if (this.plot == null) {
            LOG.warning("'lazyRefresh' called before initialized!");
        }
        LOG.debug("Scheduling refresh.");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (OverviewPlot.this.pendingRefresh.compareAndSet(this, null)) {
                    OverviewPlot.this.refresh();
                }
            }
        };
        this.pendingRefresh.set(runnable);
        this.plot.scheduleUpdate(runnable);
    }

    @Override
    public void resultAdded(Result result, Result result2) {
        this.lazyRefresh();
    }

    @Override
    public void resultChanged(Result result) {
        this.lazyRefresh();
    }

    @Override
    public void resultRemoved(Result result, Result result2) {
        this.lazyRefresh();
    }

    @Override
    public void visualizationChanged(VisualizationItem visualizationItem) {
        boolean bl = false;
        Hierarchy.Iter<VisualizationItem> iter = this.context.getVisHierarchy().iterParents(visualizationItem);
        while (iter.valid()) {
            VisualizationItem visualizationItem2 = iter.get();
            if (visualizationItem2 instanceof Projector) {
                bl = true;
                break;
            }
            iter.advance();
        }
        if (!bl) {
            this.reinitOnRefresh = true;
        }
        this.lazyRefresh();
    }

    public class SelectPlotEvent
    implements EventListener {
        PlotItem it;

        public SelectPlotEvent(PlotItem plotItem) {
            this.it = plotItem;
        }

        @Override
        public void handleEvent(Event event) {
            OverviewPlot.this.triggerSubplotSelectEvent(this.it);
        }
    }
}

