/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.gui.overview;

import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PlotItem {
    public final double x;
    public final double y;
    public final double w;
    public final double h;
    public final Projection proj;
    public List<VisualizationTask> tasks = new LinkedList<VisualizationTask>();
    public Collection<PlotItem> subitems = new LinkedList<PlotItem>();

    public PlotItem(double d, double d2, Projection projection) {
        this(0.0, 0.0, d, d2, projection);
    }

    public PlotItem(double d, double d2, double d3, double d4, Projection projection) {
        this.x = d;
        this.y = d2;
        this.w = d3;
        this.h = d4;
        this.proj = projection;
    }

    public PlotItem(PlotItem plotItem) {
        this.x = plotItem.x;
        this.y = plotItem.y;
        this.w = plotItem.w;
        this.h = plotItem.h;
        this.proj = plotItem.proj;
        this.tasks = new ArrayList<VisualizationTask>(plotItem.tasks);
        this.subitems = new ArrayList<PlotItem>(plotItem.subitems.size());
        for (PlotItem plotItem2 : plotItem.subitems) {
            this.subitems.add(new PlotItem(plotItem2));
        }
    }

    public void sort() {
        Collections.sort(this.tasks);
        for (PlotItem plotItem : this.subitems) {
            plotItem.sort();
        }
    }

    public void add(VisualizationTask visualizationTask) {
        this.tasks.add(visualizationTask);
    }

    public int taskSize() {
        return this.tasks.size();
    }

    public Iterator<PlotItem> itemIterator() {
        return new ItmItr();
    }

    public String toString() {
        return "PlotItem [x=" + this.x + ", y=" + this.y + ", w=" + this.w + ", h=" + this.h + ",proj=" + this.proj + "]";
    }

    private class ItmItr
    implements Iterator<PlotItem> {
        PlotItem next;
        Iterator<PlotItem> cur;
        Iterator<PlotItem> sub;

        public ItmItr() {
            this.next = PlotItem.this;
            this.cur = null;
            this.sub = PlotItem.this.subitems.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.cur != null && this.cur.hasNext()) {
                this.next = this.cur.next();
                return true;
            }
            if (this.sub.hasNext()) {
                this.cur = this.sub.next().itemIterator();
                return this.hasNext();
            }
            return false;
        }

        @Override
        public PlotItem next() {
            this.hasNext();
            PlotItem plotItem = this.next;
            this.next = null;
            return plotItem;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

