/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.opticsplot;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.ThumbnailRegistryEntry;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;

public class OPTICSPlot
implements Result {
    private static final Logging LOG = Logging.getLogger(OPTICSPlot.class);
    private static final int MIN_HEIGHT = 25;
    private static final int MAX_HEIGHT = 300;
    LinearScale scale;
    int width;
    int height;
    double ratio;
    final ClusterOrder co;
    final StylingPolicy colors;
    protected RenderedImage plot;
    protected int plotnum = -1;

    public OPTICSPlot(ClusterOrder clusterOrder, StylingPolicy stylingPolicy) {
        this.co = clusterOrder;
        this.colors = stylingPolicy;
    }

    public void replot() {
        this.width = this.co.size();
        this.height = (int)Math.ceil((double)this.width * 0.2);
        this.ratio = (double)this.width / (double)this.height;
        int n = this.height < 25 ? 25 : (this.height = this.height > 300 ? 300 : this.height);
        if (this.scale == null) {
            this.scale = this.computeScale(this.co);
        }
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        int n2 = 0;
        DBIDArrayIter dBIDArrayIter = this.co.iter();
        while (dBIDArrayIter.valid()) {
            double d = this.co.getReachability(dBIDArrayIter);
            int n3 = this.scaleToPixel(d);
            try {
                int n4 = this.colors.getColorForDBID(dBIDArrayIter);
                for (int i = this.height - 1; i >= n3; --i) {
                    bufferedImage.setRGB(n2, i, n4);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                LOG.error("Plotting out of range: " + n2 + "," + n3 + " >= " + this.width + "x" + this.height);
            }
            ++n2;
            dBIDArrayIter.advance();
        }
        this.plot = bufferedImage;
    }

    public int scaleToPixel(double d) {
        return Double.isInfinite(d) || Double.isNaN(d) ? 0 : (int)Math.round(this.scale.getScaled(d, (double)this.height - 0.5, 0.5));
    }

    public double scaleFromPixel(double d) {
        return this.scale.getUnscaled((d - 0.5) / ((double)this.height - 1.0));
    }

    protected LinearScale computeScale(ClusterOrder clusterOrder) {
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        DBIDArrayIter dBIDArrayIter = clusterOrder.iter();
        while (dBIDArrayIter.valid()) {
            double d = this.co.getReachability(dBIDArrayIter);
            if (d < Double.POSITIVE_INFINITY) {
                doubleMinMax.put(d);
            }
            dBIDArrayIter.advance();
        }
        if (!doubleMinMax.isValid()) {
            doubleMinMax.put(0.0);
            doubleMinMax.put(1.0);
        }
        return new LinearScale(doubleMinMax.getMin(), doubleMinMax.getMax());
    }

    public LinearScale getScale() {
        if (this.plot == null) {
            this.replot();
        }
        return this.scale;
    }

    public int getWidth() {
        if (this.plot == null) {
            this.replot();
        }
        return this.width;
    }

    public int getHeight() {
        if (this.plot == null) {
            this.replot();
        }
        return this.height;
    }

    public double getRatio() {
        if (this.plot == null) {
            this.replot();
        }
        return this.ratio;
    }

    public synchronized RenderedImage getPlot() {
        if (this.plot == null) {
            this.replot();
        }
        return this.plot;
    }

    public void forgetRenderedImage() {
        this.plotnum = -1;
        this.plot = null;
    }

    public String getSVGPlotURI() {
        if (this.plotnum < 0) {
            this.plotnum = ThumbnailRegistryEntry.registerImage(this.plot);
        }
        return "thumb:" + this.plotnum;
    }

    @Override
    public String getLongName() {
        return "OPTICS Plot";
    }

    @Override
    public String getShortName() {
        return "optics plot";
    }

    public static OPTICSPlot plotForClusterOrder(ClusterOrder clusterOrder, VisualizerContext visualizerContext) {
        StylingPolicy stylingPolicy = visualizerContext.getStylingPolicy();
        OPTICSPlot oPTICSPlot = new OPTICSPlot(clusterOrder, stylingPolicy);
        return oPTICSPlot;
    }

    public ClusterOrder getClusterOrder() {
        return this.co;
    }
}

