/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projections;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.visualization.projections.AbstractProjection;
import de.lmu.ifi.dbs.elki.visualization.projections.FullProjection;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;

public abstract class AbstractFullProjection
extends AbstractProjection
implements FullProjection {
    public AbstractFullProjection(Projector projector, LinearScale[] linearScaleArray) {
        super(projector, linearScaleArray);
    }

    @Override
    public double[] projectDataToScaledSpace(NumberVector numberVector) {
        int n = numberVector.getDimensionality();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.scales[i].getScaled(numberVector.doubleValue(i));
        }
        return dArray;
    }

    @Override
    public double[] projectDataToScaledSpace(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = this.scales[i].getScaled(dArray[i]);
        }
        return dArray2;
    }

    @Override
    public double[] projectRelativeDataToScaledSpace(NumberVector numberVector) {
        int n = numberVector.getDimensionality();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.scales[i].getRelativeScaled(numberVector.doubleValue(i));
        }
        return dArray;
    }

    @Override
    public double[] projectRelativeDataToScaledSpace(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = this.scales[i].getRelativeScaled(dArray[i]);
        }
        return dArray2;
    }

    @Override
    public double[] projectDataToRenderSpace(NumberVector numberVector) {
        return this.projectScaledToRender(this.projectDataToScaledSpace(numberVector));
    }

    @Override
    public double[] projectDataToRenderSpace(double[] dArray) {
        return this.projectScaledToRender(this.projectDataToScaledSpace(dArray));
    }

    @Override
    public double[] projectRelativeDataToRenderSpace(NumberVector numberVector) {
        return this.projectRelativeScaledToRender(this.projectRelativeDataToScaledSpace(numberVector));
    }

    @Override
    public double[] projectRelativeDataToRenderSpace(double[] dArray) {
        return this.projectRelativeScaledToRender(this.projectRelativeDataToScaledSpace(dArray));
    }

    @Override
    public <NV extends NumberVector> NV projectScaledToDataSpace(double[] dArray, NumberVector.Factory<NV> factory) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = this.scales[i].getUnscaled(dArray[i]);
        }
        return factory.newNumberVector(dArray2);
    }

    @Override
    public <NV extends NumberVector> NV projectRenderToDataSpace(double[] dArray, NumberVector.Factory<NV> factory) {
        int n = dArray.length;
        double[] dArray2 = this.projectRenderToScaled(dArray);
        for (int i = 0; i < n; ++i) {
            dArray2[i] = this.scales[i].getUnscaled(dArray2[i]);
        }
        return factory.newNumberVector(dArray2);
    }

    @Override
    public <NV extends NumberVector> NV projectRelativeScaledToDataSpace(double[] dArray, NumberVector.Factory<NV> factory) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = this.scales[i].getRelativeUnscaled(dArray[i]);
        }
        return factory.newNumberVector(dArray2);
    }

    @Override
    public <NV extends NumberVector> NV projectRelativeRenderToDataSpace(double[] dArray, NumberVector.Factory<NV> factory) {
        int n = dArray.length;
        double[] dArray2 = this.projectRelativeRenderToScaled(dArray);
        for (int i = 0; i < n; ++i) {
            dArray2[i] = this.scales[i].getRelativeUnscaled(dArray2[i]);
        }
        return factory.newNumberVector(dArray2);
    }
}

