/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projector;

import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.FilteredIter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.projector.HistogramProjector;
import de.lmu.ifi.dbs.elki.visualization.projector.ProjectorFactory;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotFactory;

public class HistogramFactory
implements ProjectorFactory {
    private int maxdim = 10;

    public HistogramFactory(int n) {
        this.maxdim = n;
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<Relation> iter = VisualizationTree.filterResults(visualizerContext, object, Relation.class);
        while (iter.valid()) {
            block4: {
                Relation relation = iter.get();
                if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                    Relation relation2;
                    FilteredIter<Relation> filteredIter = new FilteredIter<Relation>(visualizerContext.getHierarchy().iterAncestors(relation), Relation.class);
                    while (filteredIter.valid()) {
                        relation2 = (Relation)filteredIter.get();
                        if (!TypeUtil.SPATIAL_OBJECT.isAssignableFromType(relation2.getDataTypeInformation())) {
                            filteredIter.advance();
                            continue;
                        }
                        break block4;
                    }
                    relation2 = relation;
                    int n = RelationUtil.dimensionality(relation2);
                    HistogramProjector histogramProjector = new HistogramProjector(relation2, Math.min(n, this.maxdim));
                    visualizerContext.addVis(relation2, histogramProjector);
                }
            }
            iter.advance();
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private int maxdim = 10;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(ScatterPlotFactory.Parameterizer.MAXDIM_ID, 10);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (parameterization.grab(intParameter)) {
                this.maxdim = intParameter.intValue();
            }
        }

        @Override
        protected HistogramFactory makeInstance() {
            return new HistogramFactory(this.maxdim);
        }
    }
}

